#############################################################################
#
#  OpenOffice rtl_allocateMemory() Remote Code Execution Vulnerability (Lin)
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/29
#
#  Revision: 1.2
#
#  Log: schandan
#  Issue #0154
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
###########################################################################

if(description)
{
 script_id(900043);
 script_bugtraq_id(30866);
 script_cve_id("CVE-2008-3282");
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("Revision: 1.2 ");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Misc.");
 script_name(english:"OpenOffice rtl_allocateMemory() Remote Code Execution Vulnerability (Lin)");
 script_summary(english:"Check for the vulnerable version of OpenOffice.org");
 desc["english"] = "
 Overview : This host has OpenOffice.Org installed, which is prone to remote
 code execution vulnerability.
 
 Vulnerability Insight :

        The issue is due to a numeric truncation error within the rtl_allocateMemory()
        method in alloc_global.c file.

        Impact : Attackers can cause an out of bounds array access by tricking a
        user into opening a malicious document, also allow execution of arbitrary
        code.
 
 Impact Level : System
 
 Affected Software/OS :
        OpenOffice.org 2.4.1 and prior on Linux.
 
 Fix : No solution/patch is available as on 29th August, 2008. Information
 regarding this issue will updated once the solution details are available.
 For updates refer, http://download.openoffice.org/index.html
 
 References : http://secunia.com/advisories/31640/
 http://www.frsirt.com/english/advisories/2008/2449
 
 CVSS Score :
        CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
        CVSS Temporal Score : 5.8
 Risk factor : High";

 script_description(english:desc["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("Host/uname"); 
 exit(0);
}


 if("Linux" >!< get_kb_item("ssh/login/uname")){
        exit(0);
 }

 foreach item (get_kb_list("ssh/*/rpms"))
 {
	if(egrep(pattern:"^(O|o)pen(O|o)ffice.*?~([01]\..*|2\.([0-3][^0-9]" +
			 "|4(\.[01])?[^.0-9]))", string:item))
	{
 		security_warning(0);
      		exit(0);
        }
 }
