###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_php_icalendar_detect.nasl 895 2009-01-28 13:52:24Z jan $
#
# PHP iCalendar Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900198);
  script_version("Revision: 1.0 ");
  script_name(english:"PHP iCalendar Version Detection");
  desc["english"] = "
  Overview: This script detects the installed version of PHP iCalendar and
  sets the version in KB.

  Risk factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Sets the KB for the version of PHP iCalendar");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"General");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

foreach dir (make_list("/phpicalendar", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/print.php"), port:port);
  rcvRes = http_keepalive_send_recv(port:port, data:sndReq);
  if(rcvRes == NULL){
    exit(0);
  }

  if(egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes) &&
     egrep(pattern:"PHP iCalendar", string:rcvRes))
  {
    icalendarVer = eregmatch(pattern:"PHP iCalendar ([0-9.]+)", string:rcvRes);
    if(icalendarVer[1] != NULL){
       set_kb_item(name:"PHP/iCalendar/Ver", value:icalendarVer[1]);
    }
    exit(0);
  }
}
