##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_postgresql_detect_win.nasl 997 2009-03-19 14:20:24Z mar $
#
# PostgreSQL Version Detection (Windows)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900479);
  script_version("Revision: 1.0 ");
  script_name(english:"PostgreSQL Version Detection (Windows)");
  desc["english"] = "

  Overview: This script detects the installed version of PostgreSQL and
  saves the result in KB.

  Risk factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set the KB for the Version of PostgreSQL");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}

include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\PostgreSQL")){
  exit(0);
}

key = "SOFTWARE\PostgreSQL Global Development Group\PostgreSQL\";
path = registry_get_sz(key:key, item:"Location");

exePath = path + "\bin\postgres.exe";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:exePath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:exePath);

gresqlVer = GetVer(file:file, share:share);
if(gresqlVer != NULL)
{
  set_kb_item(name:"PostgreSQL/Win/Ver", value:gresqlVer);
}
