###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_proftpd_server_sql_inj_vuln.nasl 1025 2009-02-18 12:43:24Z feb $
#
# ProFTPD Server SQL Injection Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900507);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0542", "CVE-2009-0543 ");
  script_bugtraq_id(33722);
  script_name(english:"ProFTPD Server SQL Injection Vulnerability");
  desc["english"] = "

  Overview: This host is running ProFTPD Server and is prone to remote
  SQL Injection vulnerability.

  Vulnerability Insight:
  This flaw occurs because the server performs improper input sanitising,
  - when a %(percent) character is passed in the username, a single quote
    (') gets introduced during variable substitution by mod_sql and this
    eventually allows for an SQL injection during login.
  - when NLS support is enabled, a flaw in variable substition feature in
    mod_sql_mysql and mod_sql_postgres may allow an attacker to bypass
    SQL injection protection mechanisms via invalid, encoded multibyte
    characters.

  Impact:
  Successful exploitation will allow remote attackers to execute arbitrary
  SQL commands, thus gaining access to random user accounts.

  Affected Software/OS:
  ProFTPD Server version 1.3.1 through 1.3.2rc2

  Fix:
  Upgrade to the latest version 1.3.2rc3,
  http://www.proftpd.org/

  References:
  http://www.milw0rm.com/exploits/8037
  http://www.securityfocus.com/archive/1/archive/1/500833/100/0/threaded
  http://www.securityfocus.com/archive/1/archive/1/500851/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.3
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of ProFTPD Server");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"FTP");
  script_dependencies("secpod_proftpd_server_detect.nasl");
  script_require_keys("ProFTPD/Ver");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("ftp_func.inc");
include("version_func.inc");

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
  exit(0);
}

if(!get_port_state(ftpPort)){
  exit(0);
}

proftpVer = get_kb_item("ProFTPD/Ver");
if(!proftpVer){
  exit(0);
}

if(version_in_range(version:proftpVer, test_version:"1.3.1",
                    test_version2:"1.3.2.rc2")){
  security_hole(ftpPort);
}
