##############################################################################
#
#  Sun xVM VirtualBox Insecure Temporary Files Vulnerability (Win)
#
#  Copyright: SecPod
#
#  Date Written: 2008/12/02
#
#  Revision: 1.0
#
#  Log: sghosal
#  Issue #0535
#
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
##############################################################################

if(description)
{
  script_id(900407);
  script_bugtraq_id(32444);
  script_cve_id("CVE-2008-5256");
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Misc.");
  script_name(english:"Sun xVM VirtualBox Insecure Temporary Files Vulnerability (Win)");
  script_summary(english:"Check for vulnerable version of Sun xVM VirtualBox");
  desc["english"] = "
  Overview: This host is installed with Sun xVM VirtualBox and is prone to
  Insecure Temporary Files vulnerability.

  Vulnerability Insight:
  Error is due to insecured handling of temporary files in the 'AcquireDaemonLock'
  function in ipcdUnix.cpp. This allows local users to overwrite arbitrary
  files via a symlink attack on a TMP/.vbox-$USER-ipc/lock temporary file.

  Impact:
  Successful exploitation will let the attacker perform malicious actions
  with the escalated previleges.

  Impact Level: Application

  Affected Software/OS:
  Sun xVM VirutalBox version prior to 2.0.6 versions on all Windows platforms.

  Fix:
  Upgrade to the latest version 2.0.6 or above.
  http://www.virtualbox.org/wiki/Downloads

  References:
  http://secunia.com/Advisories/32851

  CVSS Score:
    CVSS Base Score     : 4.4 (AV:L/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

xvm_key  =  registry_get_sz(key:"SOFTWARE\Sun\xVM VirtualBox", item:"Version");
if(xvm_key)
{
  pattern = "^([0-1](\..*)?|2\.0(\.[0-5])?)$";
    if(egrep(pattern:pattern, string:xvm_key)){
    security_warning(0);
  }
}
