#############################################################################
#
#  Wireshark Multiple Vulnerabilities - July08 (Win)
#
#  Copyright: SecPod
#
#  Date Written: 2008/07/14
#
#  Revision: 1.2 
#
#  Log: schandan
#  Issue #0035
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900010);
 script_bugtraq_id(28485);
 script_cve_id("CVE-2008-1561", "CVE-2008-1562", "CVE-2008-1563");
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("Revision: 1.2 ");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Misc.");
 script_name(english:"Wireshark Multiple Vulnerabilities - July08 (Win)");
 script_summary(english:"Check for vulnerable version of Wireshark/Ethereal");
 desc["english"] = "
 Overview : The host is running Wireshark/Ethereal, which is prone to multiple
 vulnerabilities.

 Vulnerability Insight:
 
	The flaws exists due to errors in GSM SMS dissector, PANA and KISMET
	dissectors, RTMPT dissector, RMI dissector, and in syslog dissector.

	Impact : Successful exploitation could result in application crash,
	disclose of system memory, and an incomplete syslog encapsulated
	packets.

 Impact Level : SYSTEM

 Affected Software/OS :
	Wireshark versions prior to 1.0.1 on Windows (All).

 Quick Fix : Disable the following dissectors,
 GSM SMS, PANA, KISMET, RTMPT, and RMI

 Fix: Upgrade to wireshark to 1.0.1 or later.
 http://www.wireshark.org/download.html

 CVSS Score Report :
	CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
	CVSS Temporal Score : 5.3 
 Risk factor : High";
 script_description(english:desc["english"]);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 exit(0);
}


 include("smb_nt.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 etherealVer = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
			       "\Uninstall\Ethereal", item:"DisplayVersion");
 if(etherealVer)
 {
	etherealVer = ereg_replace(pattern:"Ethereal (.*)", replace:"\1",
                            	   string:etherealVer);
	if(ereg(pattern:"^(0\.(10\.([0-9]|1[0-4])|99\.0))$",
		string:etherealVer))
	{
		security_hole(0);
		exit(0);
	}
 }

 wiresharkVer = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
			        "\Uninstall\Wireshark", item:"DisplayVersion");
 if(!wiresharkVer){
	exit(0);
 }

 if(ereg(pattern:"^(0\.99\.[0-9]|1\.0\.0)$", string:wiresharkVer)){
	security_hole(0);
 }
