###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_xilisoft_video_conv_bof_vuln.nasl 1904 2009-04-23 15:56:36Z apr $
#
# Xilisoft Video Converter Buffer Overflow Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900630);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1370");
  script_bugtraq_id(34472);
  script_name(english:"Xilisoft Video Converter Buffer Overflow Vulnerability");
  desc["english"] = "

  Overview: This host is with installed Xilisoft Video Converter and is prone
  to Buffer Overflow Vulnerability.

  Vulnerability Insight:
  The cause is due to an error in ape_plugin.plg when parsing malicious .CUE
  files containing overly long string.

  Impact:
  This issue can be exploited to corrupt the memory and to execute arbitrary
  code in the context of the affected application.

  Impact Level: Application

  Affected Software/OS:
  Xilisoft Video Converter version 3.x to 3.1.53.0704n and 5.x to 5.1.23.0402
  on Windows.

  Fix: No solution or patch is available as on 27th April, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.xilisoft.com/

  References:
  http://secunia.com/advisories/34660
  http://www.milw0rm.com/exploits/8452
  http://xforce.iss.net/xforce/xfdb/49807

  CVSS Score:
    VSS Base Score      : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor :Critical";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Xilisoft Video Converter");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Buffer overflow");
  script_dependencies("secpod_xilisoft_video_conv_detect.nasl");
  script_require_keys("Xilisoft/Video/Conv/Ver");
  exit(0);
}


include("version_func.inc");

xsoftVer = get_kb_item("Xilisoft/Video/Conv/Ver");
if(!xsoftVer){
  exit(0);
}

if(version_in_range(version:xsoftVer, test_version:"3.0", test_version2:"3.1.53.0704n") ||
   version_in_range(version:xsoftVer, test_version:"5.0", test_version2:"5.1.23.0402")){
  security_hole(0);
}
