###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_xilisoft_video_conv_detect.nasl 1904 2009-04-23 90:07:05Z apr$
#
# Xilisoft Video Converter Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 secpod http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
##############################################################################

if(description)
{
  script_id(900629);
  script_version("$Revision: 1.0 $");
  script_name(english:"Xilisoft Video Converter Version Detection");
  desc["english"] = "

  Overview: The script will detects the Xilisoft Video Converter installed
  on this host and sets the version in KB.

  Risk factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Sets KB for the version of Xilisoft Video Converter");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  xilisoftName= registry_get_sz(item:"DisplayName", key:key +item);
  xilisoftConf = registry_get_sz(item:"UninstallString", key:key + item);

  if(("Video Converter" >< xilisoftName) && ("Xilisoft" >< xilisoftConf))
  {
    xilisoftVer = registry_get_sz(item:"DisplayVersion", key:key + item);
    if(xilisoftVer != NULL){
      set_kb_item(name:"Xilisoft/Video/Conv/Ver", value:xilisoftVer);
    }
    exit(0);
  }
}
