#
# This script was written by Carsten Koch-Mauthe <c.koch-mauthe at dn-systems.de>
#
# This script is released under the GNU GPLv2
#
# $Revision: 01 $

if(description)
{

 script_id(90013);
 script_version ("$Revision: 01 $");
 script_cve_id("CVE-2008-1238","CVE-2008-1240","CVE-2008-1241");
 name["english"] = "Mozilla Firefox, Thunderbird, Seamonkey. Several vulnerabilitys (Win)";
 script_name(english:name["english"]);

 desc["english"] = "The remote host is probable affected by the vulnerabilitys described in 
CVE-2008-0416, CVE-2007-4879, CVE-2008-1195, CVE-2008-1233,
CVE-2008-1234, CVE-2008-1235, CVE-2008-1236, CVE-2008-1237,
CVE-2008-1238, CVE-2008-1240, CVE-2008-1241 and more.


Impact
     Mozilla contributors moz_bug_r_a4, Boris Zbarsky, 
     and Johnny Stenback reported a series of vulnerabilities 
     which allow scripts from page content to run with elevated
     privileges. moz_bug_r_a4 demonstrated additional variants
     of MFSA 2007-25 and MFSA2007-35 (arbitrary code execution
     through XPCNativeWrapper pollution). Additional 
     vulnerabilities reported separately by Boris Zbarsky, 
     Johnny Stenback, and moz_bug_r_a4 showed that the browser
     could be forced to run JavaScript code using the wrong 
     principal leading to universal XSS and arbitrary code execution.
     And more...


References:
    http://www.mozilla.org/security/announce/2008/mfsa2008-14.html
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0412
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0416
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-1238
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-1240
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-1241
    .
    .
    .

Solution:
    All Users should upgrade to the latest versions of Firefox, Thunderbird or Seamonkey.


Risk factor : High";

 script_description(english:desc["english"]);
 summary["english"] = "Mozilla Firefox, Thunderbird, Seamonkey. Several vulnerabilitys";
 script_summary(english:summary["english"]);
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is under GPLv2");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 exit(0);
}

#
# The code starts here
#

include("version_func.inc");
include("smbcl_func.inc");
if( check_smbcl() == 0 ) exit(0);

  test_version = "2.0.0.14";        # Test Firefox
  test_file[0] = "Programme\Mozilla Firefox\firefox.exe";
  test_file[1] = "Prog Files\Mozilla Firefox\firefox.exe";
  foreach filespec (test_file) {
    r = smbgetdir(share: "C$", dir: filespec, typ: 1 );
    if( !isnull(r) ) {
        tmp_filename = get_tmp_dir()+"tmpfile"+rand();
        if( smbgetfile(share: "C$", filename: filespec, tmp_filename: tmp_filename) ) {
          v = GetPEProductVersion(tmp_filename:tmp_filename, orig_filename:filespec);
          unlink(tmp_filename);
          if( version_is_less(version: v, test_version: test_version) ) {
            security_hole(port:0, proto:"Win_Mozilla");
            report = report + "Fileversion : C$ "+filespec + " "+v+string("\n");
            security_hole(port:0, proto:"Win_Mozilla", data:report);
          }
          break;
        } else {
          report = string("Error getting SMB-File -> "+get_kb_item("SMB/ERROR")) + string("\n");
          security_note(port:0, proto:"Win_Mozilla", data:report);
        }
    }
  }
  test_version = "2.0.0.14";        # Test Thunderbird
  test_file[0] = "Programme\Mozilla Thunderbird\thunderbird.exe";
  test_file[1] = "Prog Files\Mozilla Thunderbird\thunderbird.exe";
  foreach filespec (test_file) {
    r = smbgetdir(share: "C$", dir: filespec, typ: 1 );
    if( !isnull(r) ) {
        tmp_filename = get_tmp_dir()+"tmpfile"+rand();
        if( smbgetfile(share: "C$", filename: filespec, tmp_filename: tmp_filename) ) {
          v = GetPEProductVersion(tmp_filename:tmp_filename, orig_filename:filespec);
          unlink(tmp_filename);
          if( version_is_less(version: v, test_version: test_version) ) {
            security_hole(port:0, proto:"Win_Mozilla");
            report = report + "Fileversion : C$ "+filespec + " "+v+string("\n");
            security_hole(port:0, proto:"Win_Mozilla", data:report);
          }
          break;
        } else {
          report = string("Error getting SMB-File -> "+get_kb_item("SMB/ERROR")) + string("\n");
          security_note(port:0, proto:"Win_Mozilla", data:report);
        }
    }
  }
  test_version = "1.1.9";        # Test SeaMonkey
  test_file[0] = "Programme\mozilla.org\SeaMonkey\seamonkey.exe";
  test_file[1] = "Prog Files\mozilla.org\SeaMonkey\seamonkey.exe";
  foreach filespec (test_file) {
    r = smbgetdir(share: "C$", dir: filespec, typ: 1 );
    if( !isnull(r) ) {
        tmp_filename = get_tmp_dir()+"tmpfile"+rand();
        if( smbgetfile(share: "C$", filename: filespec, tmp_filename: tmp_filename) ) {
          v = GetPEProductVersion(tmp_filename:tmp_filename, orig_filename:filespec);
          unlink(tmp_filename);
          if( version_is_less(version: v, test_version: test_version) ) {
            security_hole(port:0, proto:"Win_Mozilla");
            report = report + "Fileversion : C$ "+filespec + " "+v+string("\n");
            security_hole(port:0, proto:"Win_Mozilla", data:report);
          }
          break;
        } else {
          report = string("Error getting SMB-File -> "+get_kb_item("SMB/ERROR")) + string("\n");
          security_note(port:0, proto:"Win_Mozilla", data:report);
        }
    }
  }

exit(0);
