# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-717-2 (firefox-3.0)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63399);
 script_cve_id("CVE-2009-0355", "CVE-2009-0357");
 script_version ("$");
 name["english"] = "Ubuntu USN-717-2 (firefox-3.0)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to firefox-3.0
announced via advisory USN-717-2.

Details follow:

A flaw was discovered in the browser engine when restoring closed tabs. If a
user were tricked into restoring a tab to a malicious website with form input
controls, an attacker could steal local files on the user's system.
(CVE-2009-0355)

Wladimir Palant discovered that Firefox did not restrict access to cookies in
HTTP response headers. If a user were tricked into opening a malicious web
page, a remote attacker could view sensitive information. (CVE-2009-0357)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 7.10:
  firefox                         2.0.0.21~20090209t122238+nobinonly-0ubuntu0.7.10.1

After a standard system upgrade you need to restart Firefox to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-717-2

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Ubuntu USN-717-2 (firefox-3.0)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Ubuntu Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"2.0.0.21~20090209t122238+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-dbg", ver:"2.0.0.21~20090209t122238+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-dev", ver:"2.0.0.21~20090209t122238+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"2.0.0.21~20090209t122238+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-libthai", ver:"2.0.0.21~20090209t122238+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox", ver:"2.0.0.21~20090209t122238+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
