# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-728-2 (firefox)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63511);
 script_cve_id("CVE-2009-0772", "CVE-2009-0774", "CVE-2009-0776");
 script_version ("$");
 name["english"] = "Ubuntu USN-728-2 (firefox)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to firefox
announced via advisory USN-728-2.

Details follow:

Jesse Ruderman and Gary Kwong discovered flaws in the browser engine.
If a user were tricked into viewing a malicious website, a remote
attacker could cause a denial of service or possibly execute arbitrary
code with the privileges of the user invoking the program.
(CVE-2009-0772, CVE-2009-0774)

Georgi Guninski discovered a flaw when Firefox performed a
cross-domain redirect. An attacker could bypass the same-origin policy
in Firefox by utilizing nsIRDFService and steal private data from
users authenticated to the redirected website. (CVE-2009-0776)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 7.10:
  firefox                         2.0.0.21~tb.21+nobinonly-0ubuntu0.7.10.1

After a standard system upgrade you need to restart Firefox to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-728-2

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Ubuntu USN-728-2 (firefox)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Ubuntu Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"2.0.0.21~tb.21+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-dbg", ver:"2.0.0.21~tb.21+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-dev", ver:"2.0.0.21~tb.21+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"2.0.0.21~tb.21+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-libthai", ver:"2.0.0.21~tb.21+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox", ver:"2.0.0.21~tb.21+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
