###############################################################################
# OpenVAS Vulnerability Test
# $Id: PHPMySpace_detect.nasl 6512 2010-01-25 17:49:48Z mime $
#
# PHPMySpace Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "Overview:
This host is running PHPMySpace. PHPMySpace is a social networking software
written in php.

See also:
http://popscript.com/

Risk factor : None";

if (description)
{
 script_id(100464);
 script_version ("1.0-$Revision: 6512 $");

 script_name("PHPMySpace Detection");
 script_description(desc);
 script_summary("Checks for the presence of PHPMySpace");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

dirs = make_list(cgi_dirs());

foreach dir (dirs) {

 url = string(dir, "/register.php");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
 if( buf == NULL )continue;

 if(egrep(pattern: "Powered by phpMySpace Gold", string: buf, icase: TRUE) &&
    egrep(pattern: '<meta name="generator" content="phpMySpace Gold', string: buf)) {

     if(strlen(dir)>0) {
        install=dir;
     } else {
        install=string("/");
     }

    vers = string("unknown");
    ### try to get version 
    version = eregmatch(string: buf, pattern: "phpMySpace Gold ([0-9.]+)",icase:TRUE);

    if ( !isnull(version[1]) ) {
       vers=chomp(version[1]);
       set_kb_item(name: string("cpe:/a:phpmyspace:phpmyspace:",vers,"::gold"), value: TRUE);
    } else {
       set_kb_item(name: string("cpe:/a:phpmyspace:phpmyspace:::gold"), value: TRUE);
    }

    set_kb_item(name: string("www/", port, "/phpMySpace"), value: string(vers," under ",install));

    info = string("None\n\nphpMySpace Version '");
    info += string(vers);
    info += string("' was detected on the remote host in the following directory(s):\n\n");
    info += string(install, "\n");

    desc = ereg_replace(
        string:desc,
        pattern:"None$",
        replace:info
    );

       if(report_verbosity > 0) {
         security_note(port:port,data:desc);
       }
       exit(0);

 }
}
exit(0);

