###############################################################################
# OpenVAS Vulnerability Test
# $Id: WikyBlog_38386.nasl 6823 2010-02-24 17:35:31Z mime $
#
# WikyBlog Multiple Remote Input Validation Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100506);
 script_bugtraq_id(38386);
 script_version ("1.0-$Revision: 6823 $");

 script_name("WikyBlog Multiple Remote Input Validation Vulnerabilities");

desc = "Overview:
WikyBlog is prone to multiple vulnerabilities, including an arbitrary-file-
upload issue, a cross-site scripting issue, a remote file-include
issue and a session-fixation issue.

Attackers can exploit these issues to:

- execute arbitrary script code in the browser of an unsuspecting user
  in the context of the affected site.
- steal cookie-based authentication credentials.
- upload arbitrary PHP scripts and execute them in the context of the
  webserver.
- compromise the application and the underlying system.
- hijack a user's session and gain unauthorized access to the affected
  application.

WikyBlog 1.7.3rc2 is vulnerable; other versions may also be affected.

References:
http://www.securityfocus.com/bid/38386
www.wikyblog.com

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if WikyBlog is prone to multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");
   
port = get_http_port(default:80);

if(!get_port_state(port))exit(0);

if(!can_host_php(port:port))exit(0);

dirs = make_list("/blog","/Wiky",cgi_dirs());

foreach dir (dirs) {
   
  url = string(dir,"/index.php/Special/Main/Templates?cmd=copy&which=%3Cscript%3Ealert(%27openvas-xss-test%27)%3C/script%3E"); 
  req = http_get(item:url, port:port);
  buf = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);  
  if( buf == NULL )continue;

  if(egrep(pattern: "<script>alert\('openvas-xss-test'\)</script>", string: buf, icase: TRUE)) {
     
    security_warning(port:port);
    exit(0);

  }
}

exit(0);

