###############################################################################
# OpenVAS Vulnerability Test
# $Id: adaptcms_33698.nasl 6041 2009-12-02 18:43:26Z mime $
#
# AdaptCMS Lite Cross Site Scripting and Remote File Include Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100373);
 script_bugtraq_id(33698);
 script_version ("1.0-$Revision: 6041 $");

 script_name("AdaptCMS Lite Cross Site Scripting and Remote File Include Vulnerabilities");

desc = "Overview:
AdaptCMS Lite is prone to multiple cross-site scripting
vulnerabilities and a remote file-include vulnerability because it
fails to sufficiently sanitize user-supplied data.

An attacker can exploit these issues to execute malicious PHP code
in the context of the webserver process. This may allow the attacker
to compromise the application and the underlying system. The
attacker may also execute script code in an unsuspecting user's
browser or steal cookie-based authentication credentials; other
attacks are also possible.

AdaptCMS Lite 1.4 and 1.5 are vulnerable; other versions may also
be affected.

References:
http://www.securityfocus.com/bid/33698
http://www.adaptcms.com

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if AdaptCMS Lite is prone to multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");
   
port = get_http_port(default:80);
if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

dirs = make_list("/adaptcms","/cms",cgi_dirs());

foreach dir (dirs) {
   
  url = string(dir, "/sitemap.xml"); 
  req = http_get(item:url, port:port);
  buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);  
  if( buf == NULL )continue;

  if(egrep(pattern: "Generated by AdaptCMS", string: buf, icase: TRUE)) {
     
    url = string(dir, "/index.php?view=redirect&url=javascript:alert(%22openvas-xss-test%22)");
    req = http_get(item:url, port:port);
    buf = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if( buf == NULL )exit(0);

    if(egrep(pattern: '"openvas-xss-test"', string: buf)) {
      security_warning(port:port);
      exit(0);
    }  

  }
}

exit(0);

