###############################################################################
# OpenVAS Vulnerability Test
# $Id: apcnisd_detect.nasl 5376 2009-10-05 17:43:01Z mime $
#
# apcupsd and apcnisd Detection Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100292);
 script_version ("1.0-$Revision: 5376 $");

 desc = "Overview:
   This host is running apcupsd or apcnisd . apcupsd and apcnisd
   can be used for power mangement and controlling of APC's UPS
   models.

   See also:
   http://www.apcupsd.com/

   Risk factor : None";

 script_name("apcupsd and apcnisd Detection Detection");
 script_description(desc);
 script_summary("Checks for the presence of apcupsd or apcnisd");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes");
 script_require_ports("Services/unknown", 3551, 7000);
 exit(0);
}

include("misc_func.inc");
include("global_settings.inc");

ports = make_list(7000, 3551);

foreach port (ports) {

  if(!get_port_state(port))continue;
  soc = open_sock_tcp(port);
  if(!soc)continue;
  req  = raw_string(0x00, 0x06);
  req += string("status");

  send(socket:soc, data:req);
  buf = recv(socket:soc, length:4096);
  
  if("APC" >< buf && "STATUS" >< buf) {
   register_service(port:port, proto:"apcnisd"); 
   if(report_verbosity > 0) { 
      security_note(port:port);
      exit(0);
   }   
 }  
}

exit(0);
