###############################################################################
# OpenVAS Vulnerability Test
# $Id: cherokee_37715.nasl 6391 2010-01-13 10:20:27Z mime $
#
# Cherokee Terminal Escape Sequence in Logs Command Injection Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100440);
 script_bugtraq_id(37715);
 script_cve_id("CVE-2009-4489");
 script_version ("1.0-$Revision: 6391 $");

 script_name("Cherokee Terminal Escape Sequence in Logs Command Injection Vulnerability");

desc = "Overview:
Cherokee is prone to a command-injection vulnerability because it
fails to adequately sanitize user-supplied input in logfiles.

Attackers can exploit this issue to execute arbitrary commands in
a terminal.

Cherokee 0.99.30 and prior are vulnerable.

Solution:
Updates are available. Please see the references for details.

References:
http://www.securityfocus.com/bid/37715
http://www.alobbs.com/modules.php?op=modload&name=cherokee&file=index
http://www.securityfocus.com/archive/1/508830

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Cherokee version is <= 0.99.30");
 script_category(ACT_GATHER_INFO);
 script_family("Web Servers");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}


include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

banner = get_http_banner(port: port);
if(!banner)exit(0);

if("Cherokee" >< banner) {

   if(!version = eregmatch(pattern:"Server: Cherokee/([0-9.]+)", string:banner))exit(0);
   vers = version[1];

   if(!isnull(vers)) {
     if(version_is_less_equal(version: vers, test_version:"0.99.30"))  {
          security_warning(port:port);
          exit(0);
     }
   }
 }

exit(0);     
