#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(11011);
 script_version ("$Revision: 4302 $");
 
 name = "SMB on port 445";
 script_name(name);
 
 desc = "
This script detects wether port 445 and 139 are open and
if thet are running SMB servers.

Risk factor : None";



 script_description(desc);
 
 summary = "Checks for openness of port 445";
 
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright("This script is Copyright (C) 2002 Renaud Deraison");

 family = "Windows";

 script_family(family);
 script_dependencie("find_service.nes");
 script_require_ports(139, 445);
 exit(0);
}

#
# The script code starts here
#

include("smb_nt.inc");
include("misc_func.inc");

flag = 0;

if(get_port_state(445))
{
 soc = open_sock_tcp(445);
 if(soc){
 r = smb_neg_prot(soc:soc);
 close(soc);
 if(r){
 	register_service(port:445, proto:"cifs");
	security_note(port:445, data:"A CIFS server is running on this port");
	set_kb_item(name:"SMB/transport", value:445);
	flag = 1;
      }
   }
}


if(get_port_state(139))
{
  soc = open_sock_tcp(139);
  if(soc){
	nb_remote = netbios_name(orig:string("OpenVAS", rand()));
 	nb_local  = netbios_redirector_name();
 	session_request = raw_string(0x81, 0x00, 0x00, 0x44) + 
		  raw_string(0x20) + 
		  nb_remote +
		  raw_string(0x00, 0x20)    + 
		  nb_local  + 
		  raw_string(0x00);
	send(socket:soc, data:session_request);
	r = recv(socket:soc, length:4);
	close(soc);
	if(r && (ord(r[0]) == 0x82 || ord(r[0]) == 0x83)) {
		register_service(port:139, proto:"smb");
		security_note(port:139, data:"An SMB server is running on this port");	
    		if(!flag)set_kb_item(name:"SMB/transport", value:139);
		}
	}
}

