###############################################################################
# OpenVAS Vulnerability Test
# $Id:
#
# CPE Support Functions
#
# Authors:
# Michael Wiegand <michael.wiegand@intevation.de>
#
# Updated By Sharath S <sharaths@secpod.com> On 2009-11-20
#
# Updated By Chandrashekhar B <bchandra@secpod.com>
#            Sharath S <sharaths@secpod.com> On 2009-11-30
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# This list has three entries for every KB-to-CPE conversion:
# - The KB item to look for in the KB
# - A regular expression the value of this item should be checked against
# - The KB item to set if the check was successful
list = make_list (
"SMB/WindowsVersion", "(5\.0)", "cpe:/o:microsoft:windows_2000",
"SMB/WindowsVersion", "(5\.0)", "cpe:/o:microsoft:windows_server_2000",
"SMB/WindowsVersion", "(5\.1)", "cpe:/o:microsoft:windows-nt:xp",
"SMB/WindowsVersion", "(5\.2)", "cpe:/o:microsoft:windows_server_2003",
"ssh/login/release", "(RH7.3)", "cpe:/o:redhat:linux:7.3",
"ssh/login/release", "(RH8.0)", "cpe:/o:redhat:linux:8.0",
"ssh/login/release", "(RH9)", "cpe:/o:redhat:linux:9",
"ssh/login/release", "(FC1)", "cpe:/o:fedoraproject:fedora_core:1",
"ssh/login/release", "(FC2)", "cpe:/o:fedoraproject:fedora_core:2",
"ssh/login/release", "(FC3)", "cpe:/o:fedoraproject:fedora_core:3",
"ssh/login/release", "(FC4)", "cpe:/o:fedoraproject:fedora_core:4",
"ssh/login/release", "(FC5)", "cpe:/o:fedoraproject:fedora_core:5",
"ssh/login/release", "(FC6)", "cpe:/o:fedoraproject:fedora_core:6",
"ssh/login/release", "(FC7)", "cpe:/o:fedoraproject:fedora:7",
"ssh/login/release", "(FC8)", "cpe:/o:fedoraproject:fedora:8",    # CPE project hasn't yet assigned
"ssh/login/release", "(FC9)", "cpe:/o:fedoraproject:fedora:9",    # CPE project hasn't yet assigned
"ssh/login/release", "(FC10)", "cpe:/o:fedoraproject:fedora:10",  # CPE project hasn't yet assigned
"ssh/login/release", "(FC11)", "cpe:/o:fedoraproject:fedora:11",  # CPE project hasn't yet assigned
"ssh/login/release", "(FC12)", "cpe:/o:fedoraproject:fedora:12",  # CPE project hasn't yet assigned
"ssh/login/release", "(RHENT_2.1)", "cpe:/o:redhat:enterprise_linux:2.1", # Not considering various architectures and versions
"ssh/login/release", "(RHENT_3)", "cpe:/o:redhat:enterprise_linux:3",     # Not considering various architectures and versions
"ssh/login/release", "(RHENT_4)", "cpe:/o:redhat:enterprise_linux:4",     # Not considering various architectures and versions
"ssh/login/release", "(RHENT_5)", "cpe:/o:redhat:enterprise_linux:5",     # Not considering various architectures and versions
"ssh/login/release", "(MNDK_2009.1)", "cpe:/o:mandriva:linux:2009.0",
"ssh/login/release", "(MNDK_2009.0)", "cpe:/o:mandriva:linux:2009.1",
"ssh/login/release", "(MNDK_2008.1)", "cpe:/o:mandriva:linux:2008.1",
"ssh/login/release", "(MNDK_2008.0)", "cpe:/o:mandriva:linux:2008.0",
"ssh/login/release", "(MNDK_2007.1)", "cpe:/o:mandriva:linux:2007.1",
"ssh/login/release", "(MNDK_2007.0)", "cpe:/o:mandriva:linux:2007.0",
"ssh/login/release", "(MNDK_2006.0)", "cpe:/o:mandriva:linux:2006.0",
"ssh/login/release", "(MNDK_10.2)", "cpe:/o:mandrakesoft:mandrake_linux:10.2",
"ssh/login/release", "(MNDK_10.1)", "cpe:/o:mandrakesoft:mandrake_linux:10.1",
"ssh/login/release", "(MNDK_10.0)", "cpe:/o:mandrakesoft:mandrake_linux:10.0",
"ssh/login/release", "(MNDK_9.2)", "cpe:/o:mandrakesoft:mandrake_linux:9.2",
"ssh/login/release", "(MNDK_9.1)", "cpe:/o:mandrakesoft:mandrake_linux:9.1",
"ssh/login/release", "(MNDK_8.1)", "cpe:/o:mandrakesoft:mandrake_linux:8.1",
"ssh/login/release", "(MNDK_8.0)", "cpe:/o:mandrakesoft:mandrake_linux:8.0",
"ssh/login/release", "(MNDK_7.2)", "cpe:/o:mandrakesoft:mandrake_linux:7.2",
"ssh/login/release", "(CentOS5)", "cpe:/o:centos:centos:5",
"ssh/login/release", "(CENTOS4)", "cpe:/o:centos:centos:4",
"ssh/login/release", "(CENTOS3)", "cpe:/o:centos:centos:3",
"ssh/login/release", "(CentOS2)", "cpe:/o:centos:centos:2",

# Surprisingly, there are no CPE entries for Ubuntu
"ssh/login/release", "(UBUNTU4.1)", "",
"ssh/login/release", "(UBUNTU5.04)", "",
"ssh/login/release", "(UBUNTU5.10)", "",
"ssh/login/release", "(UBUNTU6.06 LTS)", "",
"ssh/login/release", "(UBUNTU6.10)", "",
"ssh/login/release", "(UBUNTU7.04)", "",
"ssh/login/release", "(UBUNTU7.10)", "",
"ssh/login/release", "(UBUNTU8.04 LTS)", "",
"ssh/login/release", "(UBUNTU8.10)", "",
"ssh/login/release", "(UBUNTU9.04)", "",
"ssh/login/release", "(UBUNTU9.10)", "",

"ssh/login/release", "CL9", "cpe:/a:connectiva:linux:9.0",
"ssh/login/release", "CL10", "cpe:/a:connectiva:linux:10.0",

# No CPE entries for Turbo Linux
"ssh/login/release", "(TLS7)", "",
"ssh/login/release", "(TLWS7)", "",
"ssh/login/release", "(TLS8)", "",
"ssh/login/release", "(TLWS8)", "",
"ssh/login/release", "(TLDT10)", "",
"ssh/login/release", "(TLS10)", "",


"ssh/login/release", "(DEB2.2)", "cpe:/o:debian:debian_linux:2.2",
"ssh/login/release", "(DEB3.0)", "cpe:/o:debian:debian_linux:3.0",
"ssh/login/release", "(DEB3.1)", "cpe:/o:debian:debian_linux:3.1",
"ssh/login/release", "(DEB4.0)", "cpe:/o:debian:debian_linux:4.0",
"ssh/login/release", "(DEB5.0)", "cpe:/o:debian:debian_linux:5.0",

# No CPE entries for Slackware
"ssh/login/release", "(SLK12.0)", "",
"ssh/login/release", "(SLK11.0)", "",
"ssh/login/release", "(SLK10.2)", "",
"ssh/login/release", "(SLK10.1)", "",
"ssh/login/release", "(SLK10.0)", "",
"ssh/login/release", "(SLK9.1)", "",
"ssh/login/release", "(SLK9.0)", "",
"ssh/login/release", "(SLK8.1)", "",


"ssh/login/release", "(SLES11.0)", "cpe:/o:suse:linux_enterprise_server:11",
"ssh/login/release", "(SLES10.0)", "cpe:/o:suse:linux_enterprise_server:10",
"ssh/login/release", "(SLES9.0)", "cpe:/o:suse:linux_enterprise_server:9",
"ssh/login/release", "(openSUSE11.2)", "cpe:/o:novell:opensuse:11.2",
"ssh/login/release", "(openSUSE11.1)", "cpe:/o:novell:opensuse:11.1",
"ssh/login/release", "(openSUSE11.0)", "cpe:/o:novell:opensuse:11.0",
"ssh/login/release", "(openSUSE10.3)", "cpe:/o:novell:opensuse:10.3",
"ssh/login/release", "(openSUSE10.2)", "cpe:/o:novell:opensuse:10.2",
"ssh/login/release", "(SUSE11)", "cpe:/o:novell:suse_linux:11.0",
"ssh/login/release", "(SUSE10.3)", "cpe:/o:novell:suse_linux:10.3",
"ssh/login/release", "(SUSE10.2)", "cpe:/o:novell:suse_linux:10.2",
"ssh/login/release", "(SUSE10.1)", "cpe:/o:novell:suse_linux:10.1",
"ssh/login/release", "(SUSE9.3)", "cpe:/o:novell:suse_linux:9.3",
"ssh/login/release", "(SUSE9.2)", "cpe:/o:novell:suse_linux:9.2",
"ssh/login/release", "(SUSE9.1)", "cpe:/o:novell:suse_linux:9.1",
"ssh/login/release", "(SUSE9.0)", "cpe:/o:novell:suse_linux:9.0",
"ssh/login/release", "(SUSE8.2)", "cpe:/o:novell:suse_linux:8.2",
"ssh/login/release", "(SUSE8.1)", "cpe:/o:novell:suse_linux:8.1",
"ssh/login/release", "(SUSE8.0)", "cpe:/o:novell:suse_linux:8.0",
"ssh/login/release", "(SUSE7.3)", "cpe:/o:novell:suse_linux:7.3",
"ssh/login/release", "(TSL3.0.5)", "cpe:/o:trustix:secure_linux:3.0.5",
"ssh/login/release", "(TSL3.0)", "cpe:/o:trustix:secure_linux:3.0",
"ssh/login/release", "(TSL2.2)", "cpe:/o:trustix:secure_linux:2.2",
"ssh/login/release", "(TSL2.1)", "cpe:/o:trustix:secure_linux:2.1",
"ssh/login/release", "(TSL2.0)", "cpe:/o:trustix:secure_linux:2.0",
"ssh/login/release", "(TSL1.5)", "cpe:/o:trustix:secure_linux:1.5",
"ssh/login/release", "(TSL1.2)", "cpe:/o:trustix:secure_linux:1.2",
"ssh/login/release", "(TSL1.1)", "cpe:/o:trustix:secure_linux:1.1",
"ssh/login/release", "(GENTOO)", "cpe:/o:gentoo:linux",
"ssh/login/release", "(HPUX10.01)", "cpe:/o:hp:hp-ux:10.01",
"ssh/login/release", "(HPUX10.10)", "cpe:/o:hp:hp-ux:10.10",
"ssh/login/release", "(HPUX10.20)", "cpe:/o:hp:hp-ux:10.20",
"ssh/login/release", "(HPUX10.24)", "cpe:/o:hp:hp-ux:10.24",
"ssh/login/release", "(HPUX10.26)", "cpe:/o:hp:hp-ux:10.26",
"ssh/login/release", "(HPUX11.00)", "cpe:/o:hp:hp-ux:11.00",
"ssh/login/release", "(HPUX11.04)", "cpe:/o:hp:hp-ux:11.0.4",
"ssh/login/release", "(HPUX11.11)", "cpe:/o:hp:hp-ux:11.11",
"ssh/login/release", "(HPUX11.20)", "cpe:/o:hp:hp-ux:11.20",
"ssh/login/release", "(HPUX11.22)", "cpe:/o:hp:hp-ux:11.22",
"ssh/login/release", "(HPUX11.23))", "cpe:/o:hp:hp-ux:11.23",
"ssh/login/release", "(HPUX11.31)", "cpe:/o:hp:hp-ux:11.31",
"ssh/login/release", "(HPUX11.23)", "cpe:/o:hp:hp-ux:11.23",
"ssh/login/solosversion", "^([0-9.]+)", "cpe:/o:sun:solaris:",  # What about Hardware type?
"ssh/login/release", "Mac OS X (10\.[0-9]+\.[0-9]+)", "cpe:/o:apple:mac_os_x:",
"MS/IE/Version", "^([0-9])\..*", "cpe:/a:microsoft:ie:",
"Microsoft-IIS/version", "^([0-9.]+)", "cpe:/a:microsoft:iis:",
"www/*/MLDonkey/version", "^([0-9.]+-?([a-z0-9]+)?)", "cpe:/a:mldonkey:mldonkey:",
"eggdrop/version/*", "^([0-9.]+)", "cpe:/a:eggheads:eggdrop:",
"www/*/GravityX", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?", "cpe:/a:gravityboardx:gravity_board_x:",
"www/*/WebmediaExplorer", "^([0-9.]+)", "cpe:/a:webmediaexplorer:webmedia_explorer:",
"www/*/atmail", "^([0-9.]+)", "cpe:/a:atmail:atmail:",
"www/*/dokeos", "^([0-9.]+)", "cpe:/a:dokeos:dokeos:",
"www/*/nagios", "^([0-9.]+)", "cpe:/a:nagios:nagios:",
"www/*/phpWebThings", "^([0-9.]+)", "cpe:/a:phpwebthings:phpwebthings:",
"www/*/TorrentTraderClassic", "^([0-9.]+)", "cpe:/a:torrenttrader:torrenttrader_classic:",
"www/*/torrenttrader", "^([0-9.]+)", "cpe:/a:torrenttrader:torrenttrader_classic:",
"www/*/webfileexplorer", "^([0-9.]+)", "cpe:/a:webfileexplorer:web_file_explorer:",
"www/*/burning_board*", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:woltlab:burning_board:",
"znc/*/version", "^([0-9.]+)", "cpe:/a:znc:znc:",
"www/*/chora", "^([0-9.]+)", "cpe:/a:horde:chora:",
"www/*/horde", "^([0-9.]+)", "cpe:/a:horde:horde_groupware:",
"www/*/squirrelmail", "^([0-9.])", "cpe:/a:squirrelmail:squirrelmail:",
"www/*/osticket", "^([0-9.]+)", "cpe:/a:osticket:osticket:",
"dnsmasq/version", "^([0-9.]+)", "cpe:/a:thekelleys:dnsmasq:",
"Moodle/Version", "^([0-9.]+)", "cpe:/a:moodle:moodle:",
"NoticeWare/Mail/Server/Ver", "^([0-9.]+)", "cpe:/a:noticeware:noticeware_email_server_ng:",
"NetDecision/TFTP/Ver", "^([0-9.]+)", "cpe:/a:netmechanica:netdecision_tftp_server:",
"NullFTP/Server/Ver", "^([0-9.]+)", "cpe:/a:vwsolutions:null_ftp:",
"Openswan/Ver", "^([0-9.]+)(rc[0-9])?", "cpe:/a:openswan:openswan:",
"ProFTPD/Ver", "^([0-9.]+)(rc[0-9]+)?", "cpe:/a:proftpd:proftpd:",
"PostgreSQL/Remote/*/Ver", "^([0-9.]+)", "cpe:/a:postgresql:postgresql:",
"PostgreSQL/Lin/Ver", "^([0-9.]+)", "cpe:/a:postgresql:postgresql:",
"PostgreSQL/Win/Ver", "^([0-9.]+)", "cpe:/a:postgresql:postgresql:",
"PumpKIN/TFTP/Ver", "^([0-9.]+)", "cpe:/a:klever:pumpkin:",
"RaidenFTPD/Ver", "^([0-9.]+)", "cpe:/a:raidenftpd:raidenftpd:",
"Reflection/SecureIT/Linux/Ver", "^([0-9.]+)", "cpe:/a:attachmate:reflection_for_secure_it:",
"Ruby-Rails/Linux/Ver", "^([0-9.]+)", "cpe:/a:ruby_on_rails:ruby_on_rails:",
"SMTP/*/Sendmail", "^([0-9.]+)", "cpe:/a:sendmail:sendmail:",
"Services/www/*/kerio_wrf", "^([0-9.]+)", "cpe:/a:kerio:winroute_firewall:",
"SurgeMail/Ver", "^([0-9.]+([a-z0-9])?)", "cpe:/a:netwin:surgemail:",
"SolarWinds/TFTP/Ver", "^([0-9.]+)", "cpe:/a:solarwinds:tftp_server:",
"StrongSwan/Ver", "^([0-9.]+)", "cpe:/a:strongswan:strongswan:",
"Tor/Linux/Ver", "^([0-9.]+-?([a-z0-9]+)?)", " cpe:/a:tor:tor:",
"Tor/Win/Ver", "^([0-9.]+)-?([a-z0-9]+)?", "cpe:/a:tor:tor:",
"WoWRaidManager/Ver", "^([0-9.]+)", "cpe:/a:wowraidmanager:wowraidmanager:",
"WinFTP/Server/Ver", "^([0-9.]+)", "cpe:/a:wftpserver:winftp_ftp_server:",
"WSFTP/Win/Ver", "^([0-9.]+)", "cpe:/a:ipswitch:ws_ftp:",
"X11/ */version", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:x.org:x11:",
"Xitami/Ver", "^([0-9.]+([a-z][0-9]?)?)", "cpe:/a:imatix:xitami:",
"imap/*/Cyrus", "^([0-9.]+)", "cpe:/a:cmu:cyrus_imap_server:",
"nagios_statd/*/Version", "^([0-9.]+)", "cpe:/a:nagios:nagios:",
"perforce/*/version", "^([0-9]{4}[.]{1}[0-9]+/[0-9]{6})", "cpe:/a:perforce:perforce_server:",
"webmin/*/version","^([0-9.]+)", "cpe:/a:webmin:webmin:",
"zebra/banner/*", "^([0-9.]+([a-z])?)", "cpe:/a:gnu:zebra:",
"oracle_tnslsnr/*/version", "^([0-9.]+)", "cpe:/a:oracle:database_server:",
"zonealarm/version", "^([0-9.]+)", "cpe:/a:zonelabs:zonealarm:",
"www/KFWebServer", "^([0-9.]+)", "cpe:/a:key_focus:kf_web_server:",
"www/OracleApache", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:oracle:http_server:",
"OpenOffice.org/Build", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:openoffice:openoffice.org:",
"/Adobe/JRun/Ver", "^([0-9.]+)", "cpe:/a:adobe:jrun:",
"/tnftpd/Ver", "^([0-9.]+)", "cpe:/a:luke_mewburn:tnftpd:",
"7zip/Lin/Ver", "^([0-9.]+)", "cpe:/a:7-zip:7-zip:",
"AIMP/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:aimp:aimp2_audio_converter:",
"AVG/AV/Linux/Ver", "^([0-9.]+)", "cpe:/a:avg:avg_anti-virus:",
"AVG/AV/Win/Ver", "^([0-9.]+)", "cpe:/a:avg:avg_anti-virus:",
"Adobe/Acrobat/Win/Ver", "^([0-9.]+)", "cpe:/a:adobe:acrobat:",
"Adobe/Air/Linux/Ver", "^([0-9.]+)", "cpe:/a:adobe:air:",
"Adobe/Air/Win/Ver", "^([0-9.]+)", "cpe:/a:adobe:air:",
"Adobe/Flex/Win/Ver", "^([0-9.]+)", "cpe:/a:adobe:flex:",
"Adobe/Reader/Win/Ver", "^([0-9.]+)", "cpe:/a:adobe:acrobat_reader:",
"Adobe/Reader/Linux/Version", "^([0-9.]+)", "cpe:/a:adobe:acrobat_reader:",
"Adobe/ShockwavePlayer/Ver", "^([0-9.]+)", "cpe:/a:adobe:shockwave_player:",
"AdobeFlashPlayer/Win/Ver", "^([0-9.]+)", "cpe:/a:adobe:flash_player:",
"AdobeFlashPlayer/Linux/Ver", "^([0-9.]+)", "cpe:/a:adobe:flash_player:",
"Amanda/version", "^([0-9.]+)", "cpe:/a:amanda:amanda:",
"Amarok/Linux/Ver", "^([0-9.]+)", "cpe:/a:amarok:amarok:",
"Antivirus/SAVCE/version", "^([0-9.]+)", "cpe:/a:symantec:norton_antivirus:",
"Antivirus/SpySweeperEnt/version", "^([0-9.]+)", "cpe:/a:webroot_software:spy_sweeper_enterprise:",
"AnyDVD/Ver", "^([0-9.]+)", "cpe:/a:slysoft:anydvd:",
"Apache/APR-Utils/Ver", "^([0-9.]+)", "cpe:/a:apache:apr-util:",
"Apache/APR/Ver", "^([0-9.]+)", "cpe:/a:apache:portable_runtime:",
"AppleSafari/Version", "^([0-9.]+)", "cpe:/a:apple:safari:",
"ArcaVir/AntiVirus/Ver", "^(9\..*)", "cpe:/a:arcabit:arcavir_2009_antivirus_protection:",
"Asterisk-PBX/Ver", "^([0-9.]+\.[0-9])\.?(rc[0-9]+)?", "cpe:/a:digium:asterisk:",
"Audacity/Win/Ver", "^([0-9.]+)", "cpe:/a:audacity:audacity:",
"Audacity/Linux/Ver", "^([0-9.]+)", "cpe:/a:audacity:audacity:",
"Avahi/Linux/Ver", "^([0-9.]+)", "cpe:/a:avahi:avahi:",
"AvantBrowser/Ver", "^([0-9.]+)", "cpe:/a:avant_force:avant_browser:",
"Avast!/AV/Linux/Ver", "^([0-9.]+)", "cpe:/a:avast:avast_antivirus:",
"Avast!/AV/Win/Ver", "^([0-9.]+)", "cpe:/a:avast:avast_antivirus:",
"BPSoft/HexWorkshop/Ver", "^([0-9.]+)", "cpe:/a:bpsoft:hex_workshop:",
"BSPlayer/Ver", "^([0-9.]+)", "cpe:/a:bsplayer:bs.player:",
"BaoFeng/Storm/Ver", "^([0-9.]+)", "cpe:/a:baofeng:storm:",
"Becky/InternetMail/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:rimarts_inc.:becky_internet_mail:",
"BitDefender/AV/Ver", "^([0-9.]+)", "cpe:/a:bitdefender:bitdefender_antivirus:",
"BitDefender/InetSec/Ver", "^([0-9.]+)", "cpe:/a:bitdefender:internet_security:",
"Blazevideo/HDTV/Ver", "^([0-9.]+)", "cpe:/a:blazevideo:hdtv_player:",
"Bopup/Server/Ver", "^([0-9.]+)", "cpe:/a:blabsoft:bopup_communication_server:",
"Buildbot/Ver", "^([0-9.]+\.[0-9])([a-z][0-9]+)?", "cpe:/a:buildbot:buildbot:",
"BulletProof/Client/Ver", "^([0-9.]+)", "cpe:/a:bpftp:bulletproof_ftp_client:",
"CCProxy/Ver", "^([0-9.]+)", "cpe:/a:youngzsoft:ccproxy:",
"CMailServer/Ver", "^([0-9.]+)", "cpe:/a:youngzsoft:cmailserver:",
"CTorrent/Ver", "^([0-9.]+)", "cpe:/a:rahul:dtorrent:",
"Enhanced/CTorrent/Ver", "^([0-9.]+)", "cpe:/a:rahul:dtorrent:",
"Checkpoint/Manager/ipaddress", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:checkpoint:vpn-1:",
"ClamAV/Win/Ver", "^([0-9.]+)", "cpe:/a:clamav:clamav:",
"ClamAV/Lin/Ver", "^([0-9.]+)", "cpe:/a:clamav:clamav:",
"CloneCD/Ver", "^([0-9.]+)", "cpe:/a:slysoft:clonecd:",
"CloneDVD/Ver", "^([0-9.]+)", "cpe:/a:slysoft:clonedvd:",
"Cscope/Ver", "^([0-9a-z.]+)", "cpe:/a:cscope:cscope:",
"Cyrus/SASL/Ver", "^([0-9.]+)", "cpe:/a:carnegie_mellon_university:cyrus-sasl:",
"DesignWorks/Prof/Ver", "^([0-9.]+)", "cpe:/a:capilano:designworks:",
"DivX/Web/Player/Ver", "^([0-9.]+)", "cpe:/a:divx:divx_web_player:",
"Django/Linux/Ver", "^([0-9.]+)", "cpe:/a:django_project:django:",
"ESET/RemoteAdmin/Server/Ver", "^([0-9.]+)", "cpe:/a:eset:remote_administrator:",
"ESET/RemoteAdmin/Console/Ver", "^([0-9.]+)", "cpe:/a:eset:remote_administrator:",
"EasyRmtoMp3/Conv/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:mini-stream:easy_rm-mp3_converter:",
"Elecard/AVC/HD/Ver", "^([0-9.]+)", "cpe:/a:elecard:elecard_avc_hd_player:",
"Elecard/Player/Ver", "^([0-9.]+)", "cpe:/a:elecard:elecard_mpeg_player:",
"ElectraSoft/FTP/Ver", "^([0-9.]+)", "cpe:/a:electrasoft:32bit_ftp:",
"Evolution/Ver", "^([0-9.]+)", "cpe:/a:gnome:evolution:",
"F-Prot/AV/Win/Ver", "^([0-9.]+)", "cpe:/a:f-prot:f-prot_antivirus:",
"F-Prot/AV/Linux/Ver", "^([0-9.]+)", "cpe:/a:f-prot:f-prot_antivirus:",
"F-Sec/AV/ClientSecurity/Ver", "^([0-9]+\.[0-9]+)", "cpe:/a:f-secure:f-secure_client_security:",
"F-Sec/AV/IntGatekeeper/Win/Ver", "^([0-9]+\.[0-9]+)", "cpe:/a:f-secure:f-secure_internet_gatekeeper_for_windows:",
"F-Sec/IntGatekeeper/Lnx/Ver",  "^([0-9]+\.[0-9]+)", "cpe:/a:f-secure:f-secure_internet_gatekeeper_for_linux:",
"F-Sec/AV/LnxClntSec/Ver", "^([0-9]+\.[0-9]+)", "cpe:/a:f-secure:f-secure_anti-virus_linux_client_security:",
"F-Sec/AV/LnxSec/Ver", "^([0-9]+\.[0-9]+)", "cpe:/a:f-secure:f-secure_linux_security:",
"F-Sec/AV/LnxSerSec/Ver", "^([0-9]+\.[0-9]+)", "cpe:/a:f-secure:f-secure_anti-virus_linux_server_security:",
"F-Sec/AV/MSExchange/Ver", "^([0-9]+\.[0-9]+)", "cpe:/a:f-secure:f-secure_anti-virus_for_microsoft_exchange:",
"F-Sec/AV/Win/Ver", "^([0-9]+\.[0-9]+)", "cpe:/a:f-secure:f-secure_anti-virus:",
"F-Sec/AV/WindowsServers/Ver", "^([0-9]+\.[0-9]+)", "cpe:/a:f-secure:f-secure_anti-virus_for_windows_servers:",
"FFFTP/Ver", "^([0-9.]+)", "cpe:/a:jun_sota:ffftp:",
"FTPShell/Version", "^([0-9.]+)", "cpe:/a:ftpshell:ftpshell_server:",
"FileZilla/Serv/Ver", "^([0-9.]+([a-z])?)", "cpe:/a:filezilla:filezilla_server:",
"Firebird-SQL/Ver", "^([0-9.]+)", "cpe:/a:firebirdsql:firebird:",
"Firefox/Linux/Ver", "^([0-9.a-z]+)", "cpe:/a:mozilla:firefox:",
"Firefox/Win/Ver", "^([0-9.a-z]+)", "cpe:/a:mozilla:firefox:",
"Flock/Win/Ver", "^([0-9.]+)", "cpe:/a:flock:flock:",
"Flock/Linux/Ver", "^([0-9.]+)", "cpe:/a:flock:flock:",
"Foxit-WAC-Server/Ver", "^([0-9.]+)", "cpe:/a:foxitsoftware:wac_server:",
"Foxit/Reader/Ver", "^([0-9.]+)", "cpe:/a:foxitsoftware:reader:",
"Foxmail/Win/Ver", "^([0-9]\.[0-9])", "cpe:/a:foxmail:foxmail:",
"FreeDownloadManager/Ver", "^([0-9]\.[0-9])", "cpe:/a:free_download_manager:free_download_manager:",
"FreeType/Linux/Ver", "^([0-9.]+)", "cpe:/a:freetype:freetype:",
"G15Daemon/Ver", "^([0-9.]+)", "cpe:/a:g15tools:g15daemon:",
"GUPnP/Ver", "^([0-9.]+)", "cpe:/a:gupnp:gupnp:",
"Gale/Linux/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:gale:gale:",
"Ghostscript/Win/Ver", "^([0-9.]+)", "cpe:/a:ghostscript:ghostscript:",
"Ghostscript/Linux/Ver", "^([0-9.]+)", "cpe:/a:ghostscript:ghostscript:",
"Gizmo5/Linux/Ver", "^([0-9.]+)", "cpe:/a:gizmo5:gizmo:",
"GnuTLS/Win/Ver", "^([0-9.]+)", "cpe:/a:gnu:gnutls:",
"GoogleChrome/Win/Ver", "^([0-9.]+)", "cpe:/a:google:chrome:",
"GrabIt/Ver", "^([0-9]\.[0-9]+\.[0-9]+)", "cpe:/a:shemes:grabit:",
"GraphicsMagick/Linux/Ver", "^([0-9.]+)", "cpe:/a:graphicsmagick:graphicsmagick:",
"HP-LIP/Linux/Ver", "^([0-9.]+)", "cpe:/a:hp:hplip:",
"Hamster/Audio-Player/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:ondanera.net:hamster_audio_player:",
"IBM/LotusNotes/Win/Ver", "^([0-9]\.[0-9]+\.[0-9]+)", "cpe:/a:ibm:lotus_notes:",
"IBM/LotusNotes/Linux/Ver", "^([0-9]\.[0-9]+\.[0-9]+)", "cpe:/a:ibm:lotus_notes:",
"ICQ/Toolbar/Ver", "^([0-9.]+)", "cpe:/a:icq:icq_toolbar:",
"ICQ/Ver", "^([0-9]\.[0-9])", "cpe:/a:icq:icq:",
"IPSec/Tools/Ver", "^([0-9.]+)", "cpe:/a:ipsec-tools:ipsec-tools:",
"ISC/DHCP-Client/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:isc:dhcp:",
"Ichitaro/Ver", "^([0-9.]+)", "cpe:/a:ichitaro:ichitaro:",
"Ichitaro/Viewer/Ver", "^(19\..*)", "cpe:/a:justsystem:ichitaro_viewer:5.1",
"ImageMagick/Win/Ver", "^([0-9.]+)", "cpe:/a:imagemagick:imagemagick:",
"ImageMagick/Linux/Ver", "^([0-9.]+)", "cpe:/a:imagemagick:imagemagick:",
"IrfanView/Ver", "^([0-9.]+)", "cpe:/a:irfanview:irfanview:",
"Irssi/Lin/Ver", "^([0-9.]+)", "cpe:/a:irssi:irssi:",
"Java/WebStart/Linux/Ver", "^([0-9]\.[0-9_.]+)", "cpe:/a:sun:java_web_start:",
"K-Meleon/Ver", "^([0-9.]+)", "cpe:/a:christophe_thibault:k-meleon:",
"KDE/Konqueror/Ver", "^([0-9.]+)", "cpe:/a:kde:konqueror:",
"KTorrent/Linux/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:ktorrent:ktorrent:",
"Kaspersky/AV-Workstation/Ver", "^(6\.0)", "cpe:/a:kaspersky_lab:kaspersky_anti-virus:6.0::workstations",
"Kaspersky/AV-FileServer/Ver",  "^(6\.0)", "cpe:/a:kaspersky_lab:kaspersky_anti-virus:6.0.3.837::windows_file_servers:",
"Kaspersky/IntNetSec/Ver", "^(7\..*)", "cpe:/a:kaspersky_lab:kaspersky_internet_security:",
"Kaspersky/IntNetSec/Ver", "^(8\..*)", " cpe:/a:kaspersky_lab:kaspersky_internet_security_2009:", 
"Kaspersky/IntNetSec/Ver", "^(9\..*)", "cpe:/a:kaspersky_lab:kaspersky_internet_security_2010:",
"Kaspersky/AV/Ver", "^(9\..*)", "cpe:/a:kaspersky:kaspersky_anti-virus:2010",
"Kaspersky/AV/Ver", "^(8\..*)", "cpe:/a:kaspersky:kaspersky_anti-virus:2009",
"Kaspersky/AV/Ver", "^(7\..*)", "cpe:/a:kaspersky:kaspersky_anti-virus:2008",
"Kaspersky/AV/Ver", "^(6\..*)", "cpe:/a:kaspersky:kaspersky_anti-virus:2007",
"KerioMailServer/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:kerio:kerio_mailserver:",
"Kvirc/Win/Ver", "^([0-9.]+)", "cpe:/a:kvirc:kvirc:",
"LeapCMS/version", "^([0-9.]+)", "cpe:/a:gowondesigns:leap:",
"Libpng/Version", "^([0-9.]+)", "cpe:/a:libpng:libpng:",
"Linux/IBM_db2/Ver", "^([0-9]\.[0-9])", "cpe:/a:ibm:db2:",
"Lunascape/Ver", "^([0-9.]+)", "cpe:/a:lunascape:lunascape:",
"MS/IE/EXE/Ver", "^([0-9])\..*", "cpe:/a:microsoft:ie:",
"MS/LiveMessenger/Ver", "^([0-9]\.[0-9]\.[0-9])", "cpe:/a:microsoft:windows_live_messenger:",
"MS/MessengerPlus/Ver", "^([0-9.]+)", "cpe:/a:microsoft:messenger_plus%21_live:",
"MS/Money/Version", "^([0-9]+)", "cpe:/a:microsoft:money:",
"MS/Office/Ver", "^(9\..*)", "cpe:/a:microsoft:office:2000",
"MS/Office/Ver", "^(10\..*)", "cpe:/a:microsoft:office:2002",
"MS/Office/Ver", "^(11\..*)", "cpe:/a:microsoft:office:2003",
"MS/Office/Ver", "^(12\..*)", "cpe:/a:microsoft:office:2007",
"MS/Office/Viewer/Ver", "^([0-9.]+)", " ",
"MagicISOMaker/Ver", "^([0-9]\.[0-9])", "cpe:/a:magic_iso_maker:magic_iso_maker:",
"Maxthon/Ver", "^([0-9.]+)", "cpe:/a:maxthon:maxthon_browser:",
"McAfee/GroupShield/Exchange/Ver", "^([0-9.]+)", "cpe:/a:mcafee:groupshield:",
"MediaPlayerClassic/Ver", "^([0-9.]+)", "cpe:/a:rob_schultz:media_player_classic:",
"MediaWiki/Version", "^([0-9.]+)", "cpe:/a:mediawiki:mediawiki:",
"MemCached/Ver", "^([0-9.]+)", "cpe:/a:memcachedb:memcached:",
"MerakMailServer/Ver", "^([0-9.]+)", "cpe:/a:icewarp:merak_mail_server:",
"NTP/Linux/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:ntp:ntp:",
"Microsoft/VisualStudio.Net/Ver", "^(7\..*)", "cpe:/a:microsoft:visual_studio_.net:2003",
"Microsoft/VisualStudio.Net/Ver", "^(8\..*)", "cpe:/a:microsoft:visual_studio_.net:2005",
"Microsoft/VisualStudio.Net/Ver", "^(9\..*)", "cpe:/a:microsoft:visual_studio_.net:2008",
"Microsoft/VisualStudio/Ver", "^(7\..*)", "cpe:/a:microsoft:visual_studio:2003",
"Microsoft/VisualStudio/Ver", "^(8\..*)", "cpe:/a:microsoft:visual_studio:2005",
"Microsoft/VisualStudio/Ver", "^(9\..*)", "cpe:/a:microsoft:visual_studio:2008",
"MicrosoftSharePointTeamServices/version", "^(12\..*)", "cpe:/a:microsoft:sharepoint_team_services:2007",
"MikMod/Linux/Ver", "^([0-9.]+)", "cpe:/a:igno_saitz:libmikmod:",
"MiniStream/AsxToMp3/Conv/Ver", "^([0-9.]+)", "cpe:/a:mini-stream:mini-stream_to_mp3_converter:",
"MiniStream/CastRipper/Ver", "^([0-9.]+)", "cpe:/a:mini-stream:castripper:",
"MiniStream/RMDown/Ver", "^([0-9.]+)", "cpe:/a:mini-stream:mini-stream_rm_downloader:",
"MiniStream/Ripper/Ver", "^([0-9.]+)", "cpe:/a:mini-stream:ripper:",
"MiniStream/RmToMp3/Conv/Ver", "^([0-9.]+)", "cpe:/a:mini-stream:easy_rm-mp3_converter:",
"MiniStream/SSRecorder/Ver", "^([0-9.]+)", "cpe:/a:mini-stream:shadow_stream_recorder:",
"MiniStream/WMDown/Ver", "^([0-9.]+)", "cpe:/a:mini-stream:wm_downloader:",
"Mozilla/Linux/Ver", "^([0-9.]+)", "cpe:/a:mozilla:mozilla:",
"Mozilla/Win/Ver", "^([0-9.]+)", "cpe:/a:mozilla:mozilla:",
"Mutt/Ver", "^([0-9.]+)", "cpe:/a:mutt:mutt:",
"Netscape/Linux/Ver", "^([0-9]+)", "cpe:/a:netscape:navigator:",
"Netscape/Win/Ver", "^([0-9]+)", "cpe:/a:netscape:navigator:",
"Norton/InetSec/Ver", "^(15\..*)", "cpe:/a:symantec:norton_internet_security:2008",
"Novell/Client/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:novell:client:",
"Novell/NetIdentity/Ver", "^([0-9.]+)", "cpe:/a:novell:netidentity_client:",
"Novell/eDir/Lin/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:novell:edirectory:",
"Novell/eDir/Win/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:novell:edirectory:",
"Novell/iPrint/Ver", "^([0-9]\.[0-9]+)", "cpe:/a:novell:iprint:",
"Novell/iPrint/Client/Linux/Ver","^([0-9]\.[0-9]+)", "cpe:/a:novell:iprint_client:",
"NullLogic-Groupware/Ver", "^([0-9.]+)", "cpe:/a:nulllogic:groupware:",
"OpenJDK/Ver", "^([0-9.]+)", "cpe:/a:sun:openjdk:",
"OpenOffice/Linux/Ver", "^([0-9.]+)", "cpe:/a:openoffice:openoffice.org:",
"OpenOffice/Win/Ver", "^([0-9.]+)", "cpe:/a:openoffice:openoffice.org:",
"OpenSC/Ver", "^([0-9.]+)", "cpe:/a:opensc-project:opensc:",
"OpenSSL/Linux/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:openssl:openssl:",
"OpenSSL/Win/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:openssl:openssl:",
"Opera/Linux/Version", "^([0-9.]+)", "cpe:/a:opera:opera:",
"Opera/Win/Version", "^([0-9.]+)", "cpe:/a:opera:opera:",
"OrcaBrowser/Ver", "^([0-9]\.[0-9])", "cpe:/a:orcabrowser:orca_browser:",
"PGPDesktop/Win/Ver", "^([0-9]\.[0-9]\.[0-9])", "cpe:/a:pgp:desktop:",
"PHP/iCalendar/Ver", "^([0-9.]+)", "cpe:/a:phpicalendar:phpicalendar:",
"PPLive/Ver", "^([0-9.]+)", "cpe:/a:pplive:pplive:",
"Pango/Ver", "^([0-9.]+)", "cpe:/a:pango:pango:",
"PeaZIP/Lin/Ver", "^([0-9.]+)", "cpe:/a:giorgio_tani:peazip:",
"PeaZIP/Win/Ver", "^([0-9.]+)", "cpe:/a:giorgio_tani:peazip:",
"Pidgin/Lin/Ver", "^([0-9.]+)", "cpe:/a:pidgin:pidgin:",
"Pidgin/Win/Ver", "^([0-9.]+)", "cpe:/a:pidgin:pidgin:",
"PowerZip/Ver", "^([0-9.]+)", "cpe:/a:powerzip:powerzip:",
"PuTTY/Version", "^([0-9.]+)", "cpe:/a:putty:putty:",
"QIP/Version", "^(8\.0\..*)", "cpe:/a:qip:qip:2005",
"QtWeb/Ver", "^([0-9]\.[0-9])", "cpe:/a:qtweb:qtwe:",
"Quagga/Ver", "^([0-9.]+)", "cpe:/a:quagga:quagga_routing_software_suite:",
"QuickTime/Win/Ver", "^([0-9.]+)", "cpe:/a:apple:quicktime:",
"RealPlayer/Win/Ver", "^([0-9.]+)", "cpe:/a:realnetworks:realplayer:",
"Ruby/Lin/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:ruby-lang:ruby:",
"SDP/Downloader/Ver", "^([0-9.]+)", "cpe:/a:sdp_multimedia:streaming_download_project:",
"SLURM/Ver", "^([0-9.]+)", "cpe:/a:llnl:slurm:",
"SMB/CiscoVPNClient/Version", "^([0-9.]+)", "cpe:/a:cisco:vpn_client:",
"SMB/Office/Access/Version", "^(9\..*)", "cpe:/a:microsoft:access:2000",
"SMB/Office/Access/Version", "^(10\..*)", "cpe:/a:microsoft:access:2002",
"SMB/Office/Access/Version", "^(11\..*)", "cpe:/a:microsoft:access:2003",
"SMB/Office/Access/Version", "^(12\..*)", "cpe:/a:microsoft:access:2007",
"SMB/Office/ComptPack/Version", "^(12\..)*", "cpe:/a:microsoft:compatibility_pack_word_excel_powerpoint:2007:",
"SMB/Office/Groove/Version", "^(12\..*)", "cpe:/a:microsoft:office_groove:2007:",
"SMB/Office/VisioViewer/Ver", "^(9\..*)", "cpe:/a:microsoft:visio_viewer:2000",
"SMB/Office/VisioViewer/Ver", "^(10\..*)", "cpe:/a:microsoft:visio_viewer:2002",
"SMB/Office/VisioViewer/Ver", "^(11\..*)", "cpe:/a:microsoft:visio_viewer:2003",
"SMB/Office/VisioViewer/Ver", "^(12\..*)", "cpe:/a:microsoft:visio_viewer:2007",
"SMB/Office/Outloook/Version", "^(9\..*)", "cpe:/a:microsoft:outlook:2000",
"SMB/Office/Outloook/Version", "^(10\..*)", "cpe:/a:microsoft:outlook:2002",
"SMB/Office/Outloook/Version", "^(11\..*)", "cpe:/a:microsoft:outlook:2003",
"SMB/Office/Outloook/Version", "^(12\..*)", "cpe:/a:microsoft:outlook:2007",
"SMB/Office/Excel/Version", "^(9\..*)", "cpe:/a:microsoft:office_excel:2000",
"SMB/Office/Excel/Version", "^(10\..*)", "cpe:/a:microsoft:office_excel:2002",
"SMB/Office/Excel/Version", "^(11\..*)", "cpe:/a:microsoft:office_excel:2003",
"SMB/Office/Excel/Version", "^(12\..*)", "cpe:/a:microsoft:office_excel:2007",
"SMB/Office/PPView/Version", "^(9\..*)", "cpe:/a:microsoft:office_powerpoint_viewer:2000",
"SMB/Office/PPView/Version", "^(10\..*)", "cpe:/a:microsoft:office_powerpoint_viewer:2002",
"SMB/Office/PPView/Version", "^(11\..*)", "cpe:/a:microsoft:office_powerpoint_viewer:2003",
"SMB/Office/PPView/Version", "^(12\..*)", "cpe:/a:microsoft:office_powerpoint_viewer:2007",
"SMB/Office/PowerPnt/Version", "^(9\..*)", "cpe:/a:microsoft:office_powerpoint:2000",
"SMB/Office/PowerPnt/Version", "^(10\..*)", "cpe:/a:microsoft:office_powerpoint:2002",
"SMB/Office/PowerPnt/Version", "^(11\..*)", "cpe:/a:microsoft:office_powerpoint:2003",
"SMB/Office/PowerPnt/Version", "^(12\..*)", "cpe:/a:microsoft:office_powerpoint:2007",
"SMB/Office/PowerPntCnv/Version", "^(12\..)", "",
"SMB/Office/Publisher/Version", "^(9\..*)", "cpe:/a:microsoft:office_publisher:2000",
"SMB/Office/Publisher/Version", "^(10\..*)", "cpe:/a:microsoft:office_publisher:2002",
"SMB/Office/Publisher/Version", "^(11\..*)", "cpe:/a:microsoft:office_publisher:2003",
"SMB/Office/Publisher/Version", "^(12\..*)", "cpe:/a:microsoft:office_publisher:2007",
"SMB/Office/Word/Version", "^(9\..*)", "cpe:/a:microsoft:office_word:2000",
"SMB/Office/Word/Version", "^(10\..*)", "cpe:/a:microsoft:office_word:2002",
"SMB/Office/Word/Version", "^(11\..*)", "cpe:/a:microsoft:office_word:2003",
"SMB/Office/Word/Version", "^(12\..*)", "cpe:/a:microsoft:office_word:2007",
"SMB/Office/WordCnv/Version", "^(12\..*)", "",
"SMB/Office/WordView/Version", "^(9\..*)", "cpe:/a:microsoft:office_word_viewer:2000",
"SMB/Office/WordView/Version", "^(10\..*)", "cpe:/a:microsoft:office_word_viewer:2002",
"SMB/Office/WordView/Version", "^(11\..*)", "cpe:/a:microsoft:office_word_viewer:2003",
"SMB/Office/WordView/Version", "^(12\..*)", "cpe:/a:microsoft:office_word_viewer:2007",
"SMB/Office/XLCnv/Version", "^(12\..*)", "",
"SMB/Office/XLView/Version", "^(9\..*)", "cpe:/a:microsoft:office_excel_viewer:2000",
"SMB/Office/XLView/Version", "^(10\..*)", "cpe:/a:microsoft:office_excel_viewer:2002",
"SMB/Office/XLView/Version", "^(11\..*)", "cpe:/a:microsoft:office_excel_viewer:2003",
"SMB/Office/XLView/Version", "^(12\..*)", "cpe:/a:microsoft:office_excel_viewer:2007",
"SMB/SonicWallGlobalVPNClient/Version", "^([0-9.]+)", "cpe:/a:sonicwall:global_vpn_client:",
"Seamonkey/Linux/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:mozilla:seamonkey:",
"Seamonkey/Win/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:mozilla:seamonkey:",
"Serv-U/FTPServ/Ver", "^([0-9.]+)", "cpe:/a:rhinosoft:serv-u:",
"Services/data_protector/version", "^([0-9]\.[0-9]+)", "cpe:/a:hp:openview_storage_data_protector:",
"SonicSpot/Audoiactive/Player/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:sonicspot:audioactive_player:",
"StarDict/Linux/Ver", "^([0-9.]+)", "cpe:/a:stardict:stardict:",
"Ston3D/Standalone/Player/Lin/Ver", "^([0-9.]+)", "cpe:/a:stonetrip:s3dplayer_standalone:",
"Ston3D/Standalone/Player/Win/Ver", "^([0-9.]+)", "cpe:/a:stonetrip:s3dplayer_standalone:",
"Ston3D/Web/Player/Ver", "^([0-9.]+)", "cpe:/a:stonetrip:s3dplayer_web:",
"Subversion/Ver", "^([0-9.]+)", "cpe:/a:subversion:subversion:",
"Sun/Java/AppServer/Ver", "^([0-9.]+)", "cpe:/a:sun:java_system_application_server:",
"Sun/Java/JDK/Win/Ver", "^([0-9._]+)", "cpe:/a:sun:jdk:",
"Sun/Java/JRE/Linux/Ver", "^([0-9._]+)", "cpe:/a:sun:jre:",
"Sun/Java/JRE/Win/Ver", "^([0-9._]+)", "cpe:/a:sun:jre:",
"Sun/JavaDirServer/Linux/Ver", "^([0-9.]+)", "cpe:/a:sun:java_system_directory_server:",
"Sun/JavaDirServer/Win/Ver", "^([0-9.]+)", "cpe:/a:sun:java_system_directory_server:",
"Sun/JavaSysWebServ/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:sun:java_system_web_server:",
"Sun/JavaWebConsole/Ver", "^([0-9.]+)", "cpe:/a:sun:java_web_console:",
"Sun/JavaWebProxyServ/Ver", "^([0-9.]+)", "cpe:/a:sun:java_system_web_proxy_server:",
"Symantec/pcAnywhere/Ver", "^([0-9]+\.[0-9])", "cpe:/a:symantec:pcanywhere:",
"TFM/MMPlayer/Ver", "^([0-9]\.[0-9])", "cpe:/a:tfm:mmplayer:",
"TheGreenBow-IPSec-VPN-Client/Ver", "^([0-9.]+)", "cpe:/a:thegreenbow:thegreenbow_vpn_client:",
"Thunderbird/Linux/Ver", "^([0-9.]+)", "cpe:/a:mozilla:thunderbird:",
"Thunderbird/Win/Ver", "^([0-9.]+)", "cpe:/a:mozilla:thunderbird:",
"TightVNC/Linux/Ver", "^([0-9.]+)", "cpe:/a:tightvnc:tightvnc:",
"TightVNC/Win/Ver", "^([0-9.]+)", "cpe:/a:tightvnc:tightvnc:",
"TitanFTP/Server/Ver", "^([0-9.]+)", "cpe:/a:southrivertech:titan_ftp_server:",
"TotalVideo/Player/Ver", "^([0-9.]+?)", "cpe:/a:effectmatrix:total_video_player:",
"Transmission/Ver", "^([0-9.]+)", "cpe:/a:transmissionbt:transmission:",
"Trillian/Ver", "^([0-9.]+)", "cpe:/a:ceruleanstudios:trillian:",
"UltraISO/Ver", "^([0-9.]+)", "cpe:/a:ezbsystems:ultraiso:",
"UltraVNC/Win/Ver", "^([0-9]\.[0-9]\.[0-9])", "cpe:/a:ultravnc:ultravnc:",
"VLCPlayer/Lin/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:videolan:vlc_media_player:",
"VLCPlayer/Win/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:videolan:vlc_media_player:",
"VMware/*/Win/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:vmware:ace:",
"VMware/Player/Win/Ver", "^([0-9.]+)", "cpe:/a:vmware:player:",
"VMware/Server/Win/Ver", "^([0-9.]+)", "cpe:/a:vmware:server:",
"VMware/Workstation/Win/Ver", "^([0-9.]+)", "cpe:/a:vmware:workstation:",
"VMware/ACE/Win/Ver", "^([0-9.]+)", "cpe:/a:vmware:ace:",
"VMware/ACE\Dormant/Win/Ver", "^([0-9.]+)", "cpe:/a:vmware:ace:",
"VMware/GSX-Server/Linux/Ver", "^([0-9.]+)", "cpe:/a:vmware:gsx_server:",
"VMware/Player/Linux/Ver", "^([0-9.]+)", "cpe:/a:vmware:player:",
"VMware/Server/Linux/Ver", "^([0-9.]+)", "cpe:/a:vmware:server:",
"VMware/Workstation/Linux/Ver", "^([0-9.]+)", "cpe:/a:vmware:workstation:",
"VUPlayer/Version", "^([0-9.]+)", "cpe:/a:vuplayer:vuplayer:",
"Ventrilo/version", "^([0-9.]+)", "cpe:/a:flagship_industries:ventrilo:",
"ViPlay/MediaPlayer/Ver", "^([0-9.]+)", "cpe:/a:urusoft:viplay3:",
"VirtualCloneDrive/Ver", "^([0-9.]+)", "cpe:/a:slysoft:virtualclonedrive:",
"WebDAV/Neon/Ver", "^([0-9.]+)", "cpe:/a:webdav:neon:",
"WebcamXP/Version", "^([0-9.]+)", "cpe:/a:webcamxp:webcamxp:",
"Win/IBM-db2/Ver", "^([0-9]\.[0-9])", "cpe:/a:ibm:db2:",
"Win/MediaPlayer/Ver", "^([0-9.]+)", "cpe:/a:microsoft:windows_media_player:",
"WinGate/Ver", "^([0-9.]+)", "cpe:/a:qbik:wingate:",
"WinRAR/Ver", "^([0-9.]+)", "cpe:/a:rarlab:winrar:",
"Winamp/Version", "^([0-9.]+)", "cpe:/a:nullsoft:winamp:",
"WindowsSharePointServices/version", "^([0-9]\.[0-9])", "cpe:/a:microsoft:sharepoint_services:",
"Wireshark/Linux/Ver", "^([0-9.]+)", "cpe:/a:wireshark:wireshark:",
"Wireshark/Win/Ver", "^([0-9.]+)", "cpe:/a:wireshark:wireshark:",
"XEmacs/Win/Ver", "^([0-9.]+)", "cpe:/a:xemacs:xemacs:",
"Xilisoft/Video/Conv/Ver", "^([0-9]\.[0-9]\.[0-9]+)", "cpe:/a:xilisoft:xilisoft_video_converter:",
"Xpdf/Linux/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:foolabs:xpdf:",
"Xvid/Win/Ver", "^([0-9.]+)", "cpe:/a:xvid:xvid:",
"eZip/Version", "^([0-9.]+)", "cpe:/a:edisys:ezip_wizard:",
"dotNet/version", "^([0-9.]+)", "cpe:/a:microsoft:.net_framework:",
"iTunes/Win/Ver", "^([0-9]\.[0-9]\.[0-9])", "cpe:/a:apple:itunes:",
"ikiwiki/Ver", "^([0-9.]+)", "cpe:/a:ikiwiki:ikiwiki:",
"mpg123/Linux/Ver", "^([0-9.]+)", "cpe:/a:mpg123:mpg123:",
"mssql/SQLVersion","^(8\..*)", "cpe:/a:microsoft:sql_server:2000",
"mssql/SQLVersion","^(9\..*)", "cpe:/a:microsoft:sql_server:2005",
"nsd/version","^([0-9.]+)", "cpe:/a:nlnetlabs:nsd:",
"sybase/version", "^([0-9.]+)", "cpe:/a:sybase:",
"FTPShell/Client/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:ftpshell:ftpshell:",
"SILC/Client/Ver", "^([0-9.]+)", "cpe:/a:silcnet:silc_client:",
"MS/WPP/EntLib/Ver", "^([0-9]\.[0-9])", "cpe:/a:microsoft:enterprise_library:",
"Changetrack/Ver", "^([0-9.]+)", "cpe:/a:cameron_morland:changetrack:",
"FreeRADIUS/Ver", "^([0-9.]+)", "cpe:/a:freeradius:freeradius:",
"freeSSHd/Ver", "^([0-9.]+)", "cpe:/a:freesshd:freesshd:",
"Dovecot/Ver", "^([0-9.]+)", "cpe:/a:dovecot:dovecot:",
"IIS/*/Ver", "^([0-9])\..*", "cpe:/a:microsoft:iis:",
"www/*/AjaxPortal", "^([0-9.]+)", "cpe:/a:myiosoft.com:ajaxportal:",
"www/*/Admin-New-Tools", "^([0-9.]+)", "cpe:/a:adminnewstools:",
"www/*/Apache/Struts", "^([0-9.]+)", "cpe:/a:apache:struts:",
"www/*/b2evolution", "^([0-9.]+)", "cpe:/a:b2evolution:b2evolution:",
"www/*/Clicknet-CMS", "^([0-9.]+)", "cpe:/a:clicknet:",
"www/*/IBM/DB2MC","^([0-9.]+)", "cpe:/a:peter_kohlmann:db2_monitoring_console:",
"www/*/DM-Albums", "^([0-9.]+)", "cpe:/a:dutchmonkey:dm_album:",
"www/*/DM-FileManager", "^([0-9.]+)", "cpe:/a:dutchmonkey:dm_filemanager:",
"www/*/DokuWiki", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:dokuwiki:dokuwiki:",
"www/*/ELOG", "^([0-9]+\.[0-9]+\.[0-9]+)", "cpe:/a:stefan_ritt:elog_web_logbook:",
"www/*/OXID-eShop", "^([0-9.]+)", "cpe:/a:oxid:eshop:",
"www/*/Openfire", "^([0-9.]+)", "cpe:/a:igniterealtime:openfire:",
"www/*/FlashChat", "^([0-9.]+)", "cpe:/a:tufat:flashchat:",
"www/*/Flatchat", "^([0-9.]+)", "cpe:/a:ninjadesigns:flatchat:",
"www/*/Adobe/FMS", "^([0-9.]+)", "cpe:/a:adobe:flash_media_server:",
"www/*/Foswiki", "^([0-9.]+)", "cpe:/a:foswiki:foswiki:",
"www/*/2532|Gigs", "^([0-9.]+)", "cpe:/a:2532gigs:2532gigs:",
"www/*/ExpEngine", "^([0-9.]+)", "cpe:/a:expressionengine:expressionengine:",
"www/*/MapServer", "^([0-9.]+)", "cpe:/a:umn:mapserver:",
"www/*/MDPro", "^([0-9.]+)", "cpe:/a:maxdev:mdpro:",
"www/*/NetRisk", "^([0-9.]+)", "cpe:/a:phprisk:netrisk:",
"www/*/OpenPro", "^([0-9.]+)", "cpe:/a:openpro:openpro:",
"www/*/OpenForum", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?", "cpe:/a:2enetworx:openforum:",
"www/*/PHP", "^([0-9.]+)", "cpe:/a:php:php:",
"www/*/Pivot", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?", "cpe:/a:pivot:pivot:",
"www/*/Apache", "^([0-9.]+)", "cpe:/a:apache:http_server:",
"www/*/Apache/Mod_Jk", "^([0-9.]+)", "cpe:/a:apache:mod_jk:",
"www/*/Apache/Tiles", "^([0-9.]+)", "cpe:/a:apache:tiles:",
"www/*/ApacheTomcat", "^([0-9.]+)", "cpe:/a:apache:tomcat:",
"www/*/HP/SMH", "^([0-9.]+)", "cpe:/a:hp:system_management_homepage:",
"www/*/SMF", "^([0-9.]+)(RC[0-9])?", "cpe:/a:simplemachines:smf:",
"www/*/Squid", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?", "cpe:/a:squid-cache:squid:",
"www/*/punBB", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?", "cpe:/a:punbb:punbb:",
"www/*/webmin", "^([0-9.]+)", "cpe:/a:webmin:usermin:",
"www/*/RoboHelpServer", "^([0-9.]+)", "cpe:/a:adobe:robohelp_server:",
"www/*/ApacheRoller", "^([0-9.]+)", "cpe:/a:apache:roller:",
"www/*/Shareaza", "^([0-9.]+)", "cpe:/a:ryo-oh-ki:shareaza:",
"www/*/SineCMS", "^([0-9.]+)", "cpe:/a:sinecms:sinecms:",
"www/*/LimeSurvey", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?", "cpe:/a:limesurvey:limesurvey:",
"www/*/TemaTres", "^([0-9.]+)", "cpe:/a:r020:tematres:",
"www/*/TWiki", "^([0-9.]+)", "cpe:/a:twiki:twiki:",
"www/*/Lussumo/Vanilla", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?", "cpe:/a:lussumo:vanilla:",
"www/*/V-webmail", "^([0-9.]+)", "cpe:/a:christof_bruyland:v-webmail:",
"www/*/BurningBoard", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?", "cpe:/a:woltlab:burning_board:",
"www/*/WebSVN", "^([0-9.]+)", "cpe:/a:tigris:websvn:",
"www/*/WordPress", "^([0-9.]+)", "cpe:/a:wordpress:wordpress:",
"www/*/WordPress-Mu", "^([0-9.]+)", "cpe:/a:wordpress:wordpress_mu:",
"www/*/AN-Guestbook", "^([0-9.]+)", "cpe:/a:an_guestbook:an_guestbook:",
"www/*/TCPDB", "^([0-9.]+)", "cpe:/a:tcpdb:tcpdb:",
"www/*/dotProject", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?", "cpe:/a:dotproject:dotproject:",
"www/*/XAMPP", "^([0-9.]+)", "cpe:/a:apachefriends:xampp:",
"www/*/Ziproxy", "^([0-9.]+)", "cpe:/a:ziproxy:ziproxy:",
"www/*/Sun/JavaSysAccessMang", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:sun:java_system_access_manager:",
"www/*/Sun/OpenSSO", "^([0-9.]+)", "cpe:/a:sun:opensso_enterprise:",
"www/*/Bitweaver", "^([0-9.]+)", "cpe:/a:bitweaver:bitweaver:",
"www/*/Campsite", "^([0-9]\.[0-9]\.[0-9]+)\.?([a-z0-9]+)?", "cpe:/a:campware.org:campsite:",
"www/*/Claroline", "^([0-9.]+)", "cpe:/a:claroline:claroline:",
"www/*/Fuzzylime(cms)", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?", "cpe:/a:fuzzylime:fuzzylime_cms:",
"www/*/CUPS", "^([0-9.]+\.[0-9])\.([a-z0-9]+)?", "cpe:/a:apple:cups:",
"www/*/DotNetNuke", "^([0-9.]+)", "cpe:/a:dotnetnuke:dotnetnuke:",
"www/*/LightNEasy/NoDB", "^([0-9.]+)", "cpe:/a:lightneasy:lightneasy:",
"www/*/LightNEasy/Sqlite", "^([0-9.]+)", "cpe:/a:sqlite:sqlite:",
"www/*/Mahara", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?", "cpe:/a:mahara:mahara:",
"www/*/NatterChat", "^([0-9.]+)", "cpe:/a:natterchat:natterchat:",
"www/*/php-nuke", "^([0-9.]+)", "cpe:/a:phpnuke:php-nuke:",
"www/*/ProChatRooms", "^([0-9.]+)", "cpe:/a:pro_chat_rooms:pro_chat_rooms:",
"www/*/CuteNews", "^([0-9.]+)", "cpe:/a:cutephp:cutenews:",
"www/*/PHP-Address-Book", "^([0-9.]+)", "cpe:/a:chatelao:php_address_book:",
"www/*/cubecart","^([0-9.]+)", "cpe:/a:cubecart:cubecart:",
"www/*/php-fusion","^([0-9.]+)","cpe:/a:php-fusion:php-fusion:",
"www/*/phpMyAdmin", "^([0-9.]+).*([rc0-9]*)?", "cpe:/a:phpmyadmin:phpmyadmin:",
"www/*/postnuke", "^([0-9.]+)", "cpe:/a:postnuke:postnuke:",
"www/*/QuiXplorer", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?", "cpe:/a:claudio_klingler:quixplorer:",
"www/*/TikiWiki", "^([0-9.]+)", "cpe:/a:tikiwiki:tikiwiki:",
"www/*/TorrentTraderClassic", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?", "cpe:/a:torrenttrader:torrenttrader_classic:",
"www/*/TorrentVolve", "^([0-9.]+)", "cpe:/a:castro_xl:torrentvolve:",
"www/*/FireStats", "^([0-9.]+)[. ]?([a-z0-9]+)?", "cpe:/a:firestats:firestats:",
"www/*/FormMail", "^([0-9.]+)","cpe:/a:matt_wright:formmail:",
"www/*/FreeWebshop", "^([0-9.]+\.[0-9])\.?([r0-9]+)?", "cpe:/a:freewebshop:freewebshop:",
"www/*/GlassFish", "^([0-9.]+)", "cpe:/a:sun:glassfish",
"www/*/MLDonkey/remote/", "^([0-9.]+\.[0-9]).*([r0-9]+)?", "cpe:/a:mldonkey:mldonkey:",
"www/*/PRTGTrafficGrapher", "^([0-9.]+)", "cpe:/a:paessler:prtg_traffic_grapher:",
"www/*/RealtyWebBase", "^([0-9.]+)", "cpe:/a:realtywebware:realty_web-base:",
"www/*/SWS", "^([0-9.]+)", "cpe:/a:symantec:web_security:",
"www/*/SnitzForums", "^([0-9.]+)", "cpe:/a:snitz_forums_2000:snitz_forums:",
"www/*/TinyPHPForum", "^([0-9.]+)", "cpe:/a:tinyphpforum:tinyphpforum:",
"www/*/TinyWebGallery", "^([0-9.]+)", "cpe:/a:tinywebgallery:tinywebgallery:",
"www/*/aas", "^([0-9.]+)", "cpe:/a:klinzmann:application_access_server:",
"www/*/adaptbb", "^([0-9.]+)", "cpe:/a:adaptbb:adaptbb:",
"www/*/axigen", "^([0-9.]+)", "cpe:/a:gecad_technologies:axigen_mail_server:",
"www/*/bugzilla", "^([0-9._]+)", "cpe:/a:mozilla:bugzilla:",
"www/*/bugzilla/version", "^([0-9._]+)", "cpe:/a:mozilla:bugzilla:",
"www/*/cacti", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:cacti:cacti:",
"www/*/coppermine", "^([0-9.]+)", "cpe:/a:coppermine:coppermine_photo_gallery:",
"www/*/cutenews", "^([0-9.]+)", "cpe:/a:cutephp:cutenews:",
"www/*/cvstrac", "^([0-9.]+)", "cpe:/a:cvstrac:cvstrac:",
"www/*/deluxeBB", "^([0-9.]+)", "cpe:/a:deluxebb:deluxebb:",
"www/*/drupal", "^([0-9.]+)", "cpe:/a:drupal:drupal:",
"www/*/e107", "^([0-9.]+)", "cpe:/a:e107:e107:",
"www/*/eliteCMS", "^([0-9.]+)", "cpe:/a:elitecms:elitecms:",
"www/*/freznoshop", "^([0-9.]+)", "cpe:/a:freznoshop:freznoshop:",
"www/*/iDB", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:idb:idb:",
"www/*/invision_power_board", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:invision_power_services:invision_power_board:",
"www/*/linpha", "^([0-9.]+)", "cpe:/a:linpha:linpha:",
"www/*/mambo_mos", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:mambo-foundation:mambo:",
"www/*/mantis", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:mantis:mantis:",
"www/*/mod_perl", "^([0-9.]+)", "cpe:/a:apache:mod_perl:",
"www/*/moodle", "^([0-9.]+)", "cpe:/a:moodle:moodle:",
"www/*/moziloCMS", "^([0-9.]+)", "cpe:/a:mozilo:mozilocms:",
"www/*/net2ftp"," ^([0-9.]+)", "cpe:/a:net2ftp:net2ftp:",
"www/*/notftp", "^([0-9.]+)", "cpe:/a:wonko:notftp:",
"www/*/ntop", "^([0-9.]+)", "cpe:/a:ntop:ntop:",
"www/*/opencart", "^([0-9.]+)", "cpe:/a:opencart:opencart:",
"www/*/phorum", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:phorum:phorum:",
"www/*/phpBB", "^([0-9.]+)", "cpe:/a:phpbb:phpbb:",
"www/*/phpBugTracker", "^([0-9.]+?)", "cpe:/a:benjamin_curtis:phpbugtracker:",
"www/*/phpGroupWare", "^([0-9.]+)", "cpe:/a:phpgroupware:phpgroupware:",
"www/*/phpScheduleIt", "^([0-9.]+)", "cpe:/a:php.brickhost:phpscheduleit:",
"www/*/phpmyfaq", "^([0-9.]+)", "cpe:/a:phpmyfaq:phpmyfaq:",
"www/*/podcast_generator", "^([0-9.]+)([a-z 0-9]+)?", "cpe:/a:podcast_generator:podcast_generator:",
"www/*/serendipity", "^([0-9.]+)([-a-z0-9]+)?", "cpe:/a:s9y:serendipity:",
"www/*/vBulletin", "^([0-9.]+)","cpe:/a:vbulletin:vbulletin:",
"www/*/viewvc", "^([0-9.]+-?([a-z0-9]+)?)", "cpe:/a:viewvc:viewvc:",
"www/*/webapp","^([0-9.]+)", "cpe:/a:web_app.net:webapp:",
"www/*/webcalendar", "^([0-9.]+)", "cpe:/a:webcalendar:webcalendar:",
"www/domino/*/db", "^([0-9.]+)", "cpe:/a:lotus:domino_server:",
"cvs/*/version", "^([0-9.]+)", "cpe:/a:cvs:cvs:",
"www/*/cPCreator", "^([0-9.]+)", "cpe:/a:cpecreator:cp_creator:",
"www/*/photopost", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:photopost:photopost_php_pro:",
"www/*/Uebimiau/Webmail", "^([0-9.]+)", "cpe:/a:uebimiau:uebimiau:",
"nginx/*/version", "^([0-9.]+)", "cpe:/a:nginx:nginx:",
"www/*/sympa", "^([0-9.]+)", "cpe:/a:sympa:sympa:",
"www/*/GeoServer", "^([0-9.]+)", "cpe:/a:geoserver:geoserver:",
"www/*/linkSpheric", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?", "cpe:/a:dataspheric:linkspheric:",
"www/*/flatpress", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:flatpress:flatpress:",
"www/*/PHPGenealogie", "^([0-9.]+)", "cpe:/a:phpgenealogy:phpgenealogy:",
"www/*/OPT", "^([0-9.]+)", "cpe:/a:lanifex:outreach_project_tool:",
"www/*/Flashlight/Free", "^([0-9.]+)", "cpe:/a:ringsworld:flashlight_free_edition:",
"BackupPC/Ver", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?", "cpe:/a:craig_barratt:backuppc:",
"www/*/MRBS", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:john_beranek:meeting_room_booking_system:",
"IBM/InstallMang/Win/Ver", "^([0-9.]+)", "cpe:/a:ibm:installation_manager:",
"www/*/phplive", "^([0-9.]+)", "cpe:/a:phplivesupport.:phplive!:",
"Shibboleth/SP/Win/Ver", "^([0-9.]+)", "cpe:/a:internet2:shibboleth-sp:",
"www/*/MyMsg", "^([0-9.]+)", "cpe:/a:al4us:mymsg:",
"www/*/Jetty", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?", "cpe:/a:mortbay:jetty:",
"Serv-U/FTP/Ver", "^([0-9.]+)", "cpe:/a:rhinosoft:serv-u:",
"www/*/BLOB-Blog-System", "^([0-9.]+)", "cpe:/a:blob:blog_system:",
"CuteFTP/Home/Ver", "^([0-9.]+)", "cpe:/a:globalscape:cuteftp:",
"CuteFTP/Lite/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:globalscape:cuteftp:",
"CuteFTP/Professional/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:globalscape:cuteftp:",
"www/*/AfterLogicWebMailPro", "^([0-9.]+)", "cpe:/a:afterlogic:mailbee_webmail_pro:",
"SonicSpot/Audoiactive/Player/Ver", "^([0-9.]+)", "cpe:/a:sonicspot:audioactive_player:",
"www/*/bloofoxCMS", "^([0-9.]+)", "cpe:/a:bloofox:bloofoxcms:",
"www/*/Xerver", "^([0-9.]+)", "cpe:/a:xerver:xerver:",
"AOL/Ver", "^([0-9.]+)", "cpe:/a:aol:internet_software:",
"XM-Easy-Personal-FTP/Ver", "^([0-9.]+)", "cpe:/a:dxmsoft:xm_easy_personal_ftp_server:",
"FileCOPA-FTP-Server/Ver", "^([0-9.]+)", "cpe:/a:filecopa-ftpserver:ftp_server:",
"Alleycode-HTML-Editor/Ver", "^([0-9.]+)", "cpe:/a:konae:alleycode_html_editor:",
"GD-Graphics-Lib/Lin/Ver", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?", "cpe:/a:libgd:gd_graphics_library:",
"httpdx/*/Ver", "^([0-9.]+([a-z]+)?)", "cpe:/a:jasper:httpdx:",
"NaviCOPA/*/Ver", "^([0-9.]+)", "cpe:/a:intervations:navicopa_web_server:",
"www/*/OpenDocMan", "^([0-9.]+)", "cpe:/a:opendocman:opendocman:",
"CA/AV/Win/Ver", "^([0-9.]+)", "cpe:/a:ca:anti-virus:",
"CA/ISS/Win/Ver", "^([0-9.]+)", "cpe:/a:ca:internet_security_suite",
"CA/eTrust-EZ-AV/Win/Ver", "^([0-9.]+)", "cpe:/a:ca:etrust_ez_antivirus:",
"SystemTap/Ver", "^([0-9.]+)", "cpe:/a:systemtap:systemtap:",
"FormMax/Evaluation/Ver", "^([0-9.]+)", "cpe:/a:cutepdf:formmax:",
"www/*/eFront", "^([0-9.]+)", "cpe:/a:efrontlearning:efront:",
"QEMU/Lin/Ver", "^([0-9.]+)", "cpe:/a:qemu:qemu:",
"Gpg4win/Win/Ver", "^([0-9.]+)", "cpe:/a:gpg4win:gpg4win:",
"Kleopatra/Win/Ver", "^([0-9.]+)", "cpe:/a:kde-apps:kleopatra:",
"www/*/landesk", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:landesk:landesk_management_suite:",
"Snort/Linux/Ver", "^([0-9.]+)", "cpe:/a:snort:snort:",
"www/*/joomla", "^([0-9.]+)", "cpe:/a:joomla:joomla",
"www/*/base", "^([0-9.]+)", "cpe:/a:base:basic_analysis_and_security_engine:",
"www/*/tftgallery", "^([0-9.]+)", "cpe:/a:tftgallery:tftgallery:",
"SquidGuard/Ver", "^([0-9.]+)", "cpe:/a:squidguard:squidguard:",
"EurekaEmail/Ver", "^([0-9.]+)", "cpe:/a:eureka-email:eureka_email:",
"Pegasus/Mail/Ver", "^([0-9.]+)", "cpe:/a:pmail:pegasus_mail:",
"Strawberry/Perl/Ver", "^([0-9.]+)", "cpe:/a:perl:perl:",
"ActivePerl/Ver", "^([0-9.]+)", "cpe:/a:perl:perl:",
"www/*/sahana", "^([0-9.]+)", "cpe:/a:sahana:sahana:",
"Novell/Groupwise/Client/Win/Ver", "^([0-9.]+)", "cpe:/a:novell:groupwise:",
"ldap/*/eDirectory", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?", "cpe:/a:novell:edirectory:",
"ftp/*/Serv-U", "^([0-9.]+)","cpe:/a:rhinosoft:serv-u:",
"www/*/XOOPS", "^([0-9.]+\.[0-9])\.?([a-z0-9])?", "cpe:/a:xoops:xoops:",
"HTML-Parser/Linux/Ver", "^([0-9.]+)", "cpe:/a:derrick_oswald:html-parser:",
"JetAudio/Ver", "^([0-9.]+)", "cpe:/a:cowonamerica:cowon_media_center-jetaudio:",
"Blender/Lin/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:blender:blender:",
"FasloPlayer/Ver", "^([0-9.]+)", "cpe:/a:faslo:faslo_player:",
"Labtam/ProFTP/Ver", "^([0-9.]+)", "cpe:/a:proftpd:proftpd:",
"Sun/VirtualBox/Win/Ver", "^3\.0\..*", "cpe:/a:sun:virtualbox:",
"Sun/xVM-VirtualBox/Win/Ver", "^[0-2]\..*", "cpe:/a:sun:xvm_virtualbox:",
"Sun/VirtualBox/Lin/Ver", "^(3\..*)", "cpe:/a:sun:virtualbox:",
"Sun/VirtualBox/Lin/Ver", "^([0-2]\..*)", "cpe:/a:sun:xvm_virtualbox:",
"Axon-Virtual-PBX/Ver", "^([0-9.]+)", "cpe:/a:nch:axon_virtual_pbx:",
"www/*/UseBB", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?", "cpe:/a:usebb:usebb:",
"www/*/FrontAccounting", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?",  "cpe:/a:frontaccounting:frontaccounting:",
"HomeFTPServer/Ver", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?", "cpe:/a:downstairs.dnsalias:home_ftp_server:",
"Robo/FTP/Ver", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?" , "cpe:/a:robo-ftp:robo-ftp:",
"TYPSoft/FTP/Ver", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?", "cpe:/a:typsoft:typsoft_ftp_server:",
"Golden/FTP/Pro/Ver", "^([0-9.]+)", "cpe:/a:kmint21:golden_ftp_server:",
"Golden/FTP/Free/Ver", "^([0-9.]+)", "cpe:/a:kmint21:golden_ftp_server:",
"YahooMessenger/Ver", "^([0-9.]+)", "cpe:/a:yahoo:messenger:",
"Serenity/Audio/Player/Ver", "^([0-9.]+)", "cpe:/a:malsmith:serenity_audio_player:",
"Mplay/Audio/Player/Ver", "^([0-9.]+)", "cpe:/a:malsmith:serenity_audio_player:",
"www/*/Telepark.wiki", "^([0-9.]+)", "cpe:/a:telepark:telepark.wiki:",
"www/*/ImageHostingScript/DPI", "^([0-9.]+)", "cpe:/a:image-host-script:image_hosting_script:",
"IDEAL/Admin/Ver", "^(9\.[0-9.]+)", "cpe:/a:pointdev:ideal_administration_2009:",
"Panda/InternetSecurity/Ver", "^(15\.0)", "cpe:/a:pandasecurity:panda_internet_security:2010::pro",
"Panda/GlobalProtection/Ver", "^(3\.0)", "cpe:/a:pandasecurity:panda_global_protection:2010",
"Panda/Antivirus/Ver", "^(9\.0)", "cpe:/a:pandasecurity:panda_antivirus::2010::pro",
"www/*/YABSoft/AIHS", "^([0-9.]+)", "cpe:/a:yabsoft:advanced_image_hosting_script:",
"NASL/Linux/Ver", "^([0-9.]+)", "cpe:/a:nessus:nessus:",
"www/*/ePoAgent/Version","^([0-9.]+([a-z0-9]+)?)","cpe:/a:mcafee:epolicy_orchestrator:",
"www/*/barracuda_im_firewall", "^([0-9.]+)", "cpe:/h:barracuda_networks:barracuda_im_firewall:",
"www/*/jboss_enterprise_application_server", "^([0-9.]+)([GA_CP0-9]*)", "cpe:/a:redhat:jboss_enterprise_application_platform:",
"www/*/basilix", "^([0-9.]+\.[0-9])\.?([a-z0-9]+)?", "cpe:/a:basilix:basilix_webmail:",
"SMB/Patchlink/version", "^([0-9]+\.[0-9]+)", "cpe:/a:lumension_security:patchlink_update:",
"www/*/jdwebinterface", "^([0-9.]+)", "",
"www/*/openx", "^([0-9.]+)", "cpe:/a:openx:openx:",
"www/*/PowerPhlogger", "^([0-9.]+)", "cpe:/a:powerphlogger:powerphlogger:",
"www/*/phpshop", "^([0-9.]+)", "cpe:/a:edikon:phpshop:",
"www/*/rt_tracker", "^([0-9.]+)", "cpe:/a:best_practical_solutions:request_tracker:",
"SSH/banner/", "^([0-9.]+)", "cpe:/a:openssh:openssh:",
"www/*/phpldapadmin", "^([0-9.]+)", "cpe:/a:phpldapadmin:phpldapadmin:",
"www/*/AlefMentor", "^([0-9.]+)", "cpe:/a:findmysoft:alefmentor:",
"www/*/FamilyConnections", "^([0-9.]+)", "cpe:/a:haudenschilt:family_connections_cms:",
"Ruby/Win/Ver", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:ruby-lang:ruby:",
"www/*/Valarsoft/Webmatic", "^([0-9.]+)", "cpe:/a:valarsoft:webmatic:",
"www/*/SQL-Ledger", "^([0-9.]+)","cpe:/a:sql-ledger:sql-ledger:",
"www/*/PHP-Calendar", "^([0-9.]+)", "cpe:/a:php-calendar:php-calendar:",
"www/*/JpGraph", "^([0-9.]+)", "cpe:/a:aditus:jpgraph:",
"www/*/Ortro", "^([0-9.]+([a-z0-9]+)?)", "cpe:/a:ortro:ortro:",
"www/*/LiveZilla", "^([0-9.]+)", "cpe:/a:livezilla:livezilla:",
"Kerberos5/Ver", "^([0-9.]+)", "cpe:/a:mit:kerberos:",
"Google/SketchUp/Win/Ver", "^([0-9.]+)", "cpe:/a:google:google_sketchup:",
"www/*/phpNagios", "^([0-9.]+)", "cpe:/a:phpnagios:phpnagios:",
"SouthRiverWebDrive/Win/Ver", "^([0-9.]+)", "cpe:/a:south_river_technologies:webdrive:",
"Varnish/Ver", "^([0-9.]+)", "cpe:/a:varnish.projects.linpro:varnish:",
"GZip/Win/Ver", "^([0-9.]+)", "cpe:/a:gnu:gzip:",
"GZip/Linux/Ver", "^([0-9.]+)", "cpe:/a:gnu:gzip:",
"Maildrop/Linux/Ver", "^([0-9.]+)", "cpe:/a:maildrop:maildrop:",
"FFmpeg/Linux/Ver", "^([0-9.]+)", "cpe:/a:ffmpeg:ffmpeg:",
"NetPBM/Ver", "^([0-9.]+)", "cpe:/a:netpbm:netpbm:",
"www/*/evalSMSI", "^([0-9.]+)", "cpe:/a:myshell:evalsmsi:",
"www/*/phpBazar", "^([0-9.]+)", "cpe:/a:smartisoft:phpbazar:",
"www/*/DocManager", "^([0-9.]+)", "cpe:/a:dmanager:documentmanager:",
"www/*/BASE", "^([0-9.]+)", "cpe:/a:secureideas:base:",
"www/*/OTRS", "^([0-9.]+)", "cpe:/a:otrs:otrs:",
"www/*/JAG", "^([0-9.]+)", "cpe:/a:xs4all:jag:",
"www/*/ZeusCMS", "^([0-9.]+)", "cpe:/a:zeuscms:zeuscms:",
"www/*/Limny", "^([0-9.]+)", "cpe:/a:limny:limny:",
"Hyleos/ChemViewX/Ver", "^([0-9.]+)", "cpe:/a:hyleos:chemview:",
"www/*/WampServer", "^([0-9.]+)", "cpe:/a:wampserver:wampserver:",
"Bournal/Ver", "^([0-9.]+)", "cpe:/a:becauseinter:bournal:",
"www/*/Zenoss", "^([0-9.]+)", "cpe:/a:zenoss:zenoss:",
"www/*/moinmoinWiki", "^([0-9.]+)", "cpe:/a:moinmo:moinmoin:",
"www/*/tdiary", "^([0-9.]+)", "cpe:/a:tdiary:tdiary:",
"FirewallBuilder/Linux/Ver", "^([0-9.]+)", "cpe:/a:fwbuilder:firewall_builder:",
"www/*/phpCOIN", "^([0-9.]+)", "cpe:/a:phpcoin:phpcoin:",
"VisualizationLibrary/Win/Ver", "^([0-9.]+)", "cpe:/a:visualizationlibrary:visualization_library:"

);


function translate_to_cpe () {
  max = max_index (list) - 1;
  for (i = 0; i < max; i = i + 3) {
    z = get_kb_list(list[i]);
    if(z) {
      foreach y (z) {
        b = eregmatch(string:y, pattern:list[i + 1], icase:1);
        if (b[1]) {
          o = list[i + 2];
          m = strlen(o) - 1;
          if (":" >!< o[m]) {
            set_kb_item(name:list[i + 2], value:TRUE);
          }
          else if (b[1] && b[2]) {
            set_kb_item(name:list[i + 2] + b[1] + ":" + b[2], value:TRUE);
          }
          else if (b[1]) {
            set_kb_item(name:list[i + 2] + b[1], value:TRUE);
          }
        }
      }
    }
  }
}
