###############################################################################
# OpenVAS Vulnerability Test
# $Id:
#
# CPE Inventory
#
# Authors:
# Michael Wiegand <michael.wiegand@intevation.de>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(810002);
  script_version("$Revision: 1.0 $");
  script_name("CPE Inventory");
  desc["english"] = "CPE Inventory

  This NVT uses information present in the Knowledge Base (KB) to
  determine CPE identities (http://cpe.mitre.org/) of operating
  systems, services and applications detected during the scan.

  Risk Factor: None";

  script_description(desc["english"]);
  script_summary("CPE Inventory");
  script_category(ACT_END);
  script_copyright("Copyright (c) 2009 Greenbone Networks GmbH");
  script_family("Service detection");
  exit(0);
}


include("cpe.inc");

translate_to_cpe ();

cpes = get_kb_list("cpe:/*");
if (isnull (cpes))
{
  log_message (proto: "CPE", data: 'No CPE identities could be determined.');
}
else
{
  report = '';

  ip = get_host_ip ();

  # TODO: Ultimately, this report should also contain
  # the OID of the NVT which found this OS/App/Service
  # and the port it was found listening on, if applicable.
  foreach cpe (keys(cpes))
  {
    report = report + ip + '|' + cpe + '\n';
  }

  log_message (proto: "CPE-T", data: report);
}
