###############################################################################
# OpenVAS Vulnerability Test
# $Id: cubecart_37065.nasl 5951 2009-11-24 11:49:20Z mime $
#
# CubeCart 'productId' SQL Injection Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100360);
 script_bugtraq_id(37065);
 script_version ("1.0-$Revision: 5951 $");

 script_name("CubeCart 'productId' SQL Injection Vulnerability");

desc = "Overview:
CubeCart is prone to an SQL-injection vulnerability because it fails
to sufficiently sanitize user-supplied data before using it in an
SQL query.

Exploiting this issue could allow an attacker to compromise the
application, access or modify data, or exploit latent vulnerabilities
in the underlying database.

The issue affects CubeCart 4.3.6; prior versions may also be affected.

Solution:
The vendor has released updates. Please see the references for
details.

References:
http://www.securityfocus.com/bid/37065
http://forums.cubecart.com/index.php?showtopic=39900
www.cubecart.com

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if CubeCart version is 4.3.6");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("secpod_cubecart_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);


if(!version = get_kb_item(string("www/", port, "/cubecart")))exit(0);

if(!isnull(version)) {

  if(version_is_equal(version: version, test_version: "4.3.6")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
