#####################################################################
#
#
# Josh Zlatin-Amishav <josh at ramat dot cc>
#
# This script is released under the GNU GPLv2
#
# Updated: 04/07/2009
# Antu Sanadi <santu@secpod.com>
#
###################################################################

if(description)
{
  script_id(19945);
  script_cve_id("CVE-2005-3152");
  script_bugtraq_id(14962);
  script_version ("$Revision: 4302 $");
  script_name("Multiple CubeCart XSS vulnerabilities");
  desc = "
  Description :
  The remote version of CubeCart contains several cross-site scripting
  vulnerabilities to due to its failure to properly sanitize user-supplied
  input of certain variables to the 'index.php' and 'cart.php' scripts.

  See also:
  http://lostmon.blogspot.com/2005/09/cubecart-303-multiple-variable-cross.html
  Solution:
  Upgrade to CubeCart version 3.0.4 or later.
  Risk factor:

  Low / CVSS Base Score : 3
  (AV:R/AC:H/Au:NR/C:P/A:N/I:N/B:C)";

  script_description(desc);
  script_summary("Checks for XSS in index.php");
  script_category(ACT_ATTACK);
  script_family("Web application abuses");
  script_copyright("Copyright (C) 2005 Josh Zlatin-Amishav");
  script_dependencies("secpod_cubecart_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port)){
  exit(0);
}

version = get_kb_item(string("www/", port, "/cubecart"));
if(!version){
  exit(0);
}

if(!safe_checks())
{
  foreach dir (make_list("/cubecart/upload","/upload", cgi_dirs()))
  {
    xss = "<script>alert('" + SCRIPT_NAME + "');</script>";
    exss = urlencode(str:xss);
    req = http_get(item:string(dir, "/index.php?",'searchStr=">', exss,
         "&act=viewCat&Submit=Go"),port:port);
    res = http_send_recv(port:port, data:req);
    if(xss >< res)
    {
      security_note(port);
      exit(0);
    }
  }
}

if(version_is_less_equal(version:version, test_version:"3.0.3")){
  security_warning(port);
}
