# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 013-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53776);
 script_version ("$");
 name = "Debian Security Advisory DSA 013-1 (mysql)";
 script_name(name);

 desc = "The remote host is missing an update to mysql
announced via advisory DSA 013-1.

Nicolas Gregoire has reported a buffer overflow in the mysql server
that leads to a remote exploit.  An attacker could gain mysqld
privileges (and thus gaining access to all the databases).

We recommend you upgrade your mysql package immediately.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20013-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 013-1 (mysql)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mysql-doc", ver:"3.22.32-4", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-client", ver:"3.22.32-4", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-server", ver:"3.22.32-4", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mysql", ver:"4.0.3pl1-0potato1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
