# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 030-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53792);
 script_version ("$");
 name = "Debian Security Advisory DSA 030-1 (xfree86-1)";
 script_name(name);

 desc = "The remote host is missing an update to xfree86-1
announced via advisory DSA 030-1.

Chris Evans, Joseph S. Myers, Michal Zalewski, Alan Cox, and others have
noted a number of problems in several components of the X Window System
sample implementation (from which XFree86 is derived).  While there are no
known reports of real-world malicious exploits of any of these problems, it
is nevertheless suggested that you upgrade your XFree86 packages
immediately.

The scope of this advisory is XFree86 3.3.6 only, since that is the version
released with Debian GNU/Linux 2.2 ('potato'); Debian packages of XFree86
4.0 and later have not been released as part of a Debian distribution.

Several people are responsible for authoring the fixes to these problems,
including Aaron Campbell, Paulo Cesar Pereira de Andrade, Keith Packard,
David Dawes, Matthieu Herrb, Trevor Johnson, Colin Phipps, and Branden
Robinson.

For a more detailed description of the problems addressed, please visit
the referenced security advisory.

These problems have been fixed in version 3.3.6-11potato32 and we recommand
that you upgrade your X packages immediately.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20030-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 030-1 (xfree86-1)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"rstart", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xbase", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfree86-common", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rstartd", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"twm", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xbase-clients", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xdm", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xext", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xf86setup", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfs", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlib6g-dev", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlib6g-static", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlib6g", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xmh", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xnest", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xproxy", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xprt", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-3dlabs", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-common", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-fbdev", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-i128", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-mach64", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-mono", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-p9000", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-s3", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-s3v", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-svga", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-tga", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-vga16", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xsm", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xterm", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xvfb", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlib6-altdev", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlib6", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-8514", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-agx", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-mach32", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-mach8", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-w32", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-xsun-mono", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-xsun24", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-xsun", ver:"3.3.6-11potato32", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
