# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 031-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53793);
 script_version ("$");
 name = "Debian Security Advisory DSA 031-1 (sudo)";
 script_name(name);

 desc = "The remote host is missing an update to sudo
announced via advisory DSA 031-1.

Todd Miller announced a new version of sudo which corrects a buffer
overflow that could potentially be used to gain root privilages on the
local system. The fix from sudo 1.6.3p6 is available in sudo
1.6.2p2-1potato1 for Debian 2.2 (potato).

We recommend you upgrade your sudo package immediately.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20031-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 031-1 (sudo)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"sudo", ver:"1.6.2p2-1potato1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
