# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 051-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53564);
 script_version ("$");
 name = "Debian Security Advisory DSA 051-1 (netscape)";
 script_name(name);

 desc = "The remote host is missing an update to netscape
announced via advisory DSA 051-1.

Florian Wesch has discovered a problem (reported to bugtraq) with the
way how Netscape handles comments in GIF files.  The Netscape browser
does not escape the GIF file comment in the image information page.
This allows javascript execution in the 'about:' protocol and can for
example be used to upload the History (about:global) to a webserver,
thus leaking private information.  This problem has been fixed
upstream in Netscape 4.77.  Since we haven't received sourcecode for
these packages they are not part of the Debian GNU/Linux distribution
but are packaged up as `.deb' files for a convenient installation.

We recommend that you upgrade your Netscape packages immediately and


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20051-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 051-1 (netscape)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"netscape-ja-resource-477", ver:"4.77-2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"netscape-java-477", ver:"4.77-2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"netscape-ko-resource-477", ver:"4.77-2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"netscape-zh-resource-477", ver:"4.77-2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"navigator-nethelp-477", ver:"4.77-2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"communicator-nethelp-477", ver:"4.77-2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"communicator-spellchk-477", ver:"4.77-2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"netscape", ver:"4.77-1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"netscape-base-4-libc5", ver:"4.77-1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"netscape-base-4", ver:"4.77-1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"navigator", ver:"4.77-1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"communicator", ver:"4.77-1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"netscape-base-477", ver:"4.77-2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"netscape-smotif-477", ver:"4.77-2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"navigator-base-477", ver:"4.77-2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"navigator-smotif-477", ver:"4.77-2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"communicator-base-477", ver:"4.77-2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"communicator-smotif-477", ver:"4.77-2", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
