# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 077-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53825);
 script_version ("$");
 name = "Debian Security Advisory DSA 077-1 (squid)";
 script_name(name);

 desc = "The remote host is missing an update to squid
announced via advisory DSA 077-1.

Vladimir Ivaschenko found a problem in squid (a popular proxy cache).
He discovered that there was a flaw in the code to handle FTP PUT
commands: when a mkdir-only request was done squid would detect
an internal error and exit. Since squid is configured to restart
itself on problems this is not a big problem.

This has been fixed in version 2.2.5-3.2. This problem is logged
as bug 233 in the squid bugtracker and will also be fixed in
future squid releases.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20077-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 077-1 (squid)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"squid-cgi", ver:"2.2.5-3.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid", ver:"2.2.5-3.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squidclient", ver:"2.2.5-3.2", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
