# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 088-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53828);
 script_version ("$");
 name = "Debian Security Advisory DSA 088-1 (fml)";
 script_name(name);

 desc = "The remote host is missing an update to fml
announced via advisory DSA 088-1.

The fml (a mailing list package) as distributed in Debian GNU/Linux 2.2
suffers from a cross-site scripting problem. When generating index
pages for list archives the `<' and `>' characters were not properly
escaped for subjects.

This has been fixed in version 3.0+beta.20000106-5, and we recommend
that you upgrade your fml package to that version. Upgrading will
automatically regenerate the index pages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20088-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 088-1 (fml)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"fml", ver:"3.0+beta.20000106-5", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
