# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 102-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53762);
 script_version ("$");
 name = "Debian Security Advisory DSA 102-2 (at)";
 script_name(name);

 desc = "The remote host is missing an update to at
announced via advisory DSA 102-2.

Basically, this is the same Security Advisory as DSA 102-1, except
that the uploaded binary packages really fix the problem this time.
Unfortunately the bugfix from DSA 102-1 wasn't propagated properly due
to a packaging bug.  While the file parsetime.y was fixed, and
yy.tab.c should be generated from it, yy.tab.c from the original
source was still used.  This has been fixed now.

The original advisory said:

zen-parse found a bug in the current implementation of at which leads
into a heap corruption vulnerability which in turn could potentially
lead into an exploit of the daemon user.

This has been fixed in at 3.1.8-10.2 for the stable Debian release and
3.1.8-11 for the unstable and testing release.  Packages for unstable
have just been uploaded into <http://incoming.debian.org/>.  We
recommend that you upgrade your at packages immediately since an
exploit has already been published.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20102-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 102-2 (at)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"at", ver:"3.1.8-10.2", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
