# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1091-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56923);
 script_cve_id("CVE-2006-2656", "CVE-2006-2193");
 script_version ("$");
 name = "Debian Security Advisory DSA 1091-1 (tiff)";
 script_name(name);

 desc = "The remote host is missing an update to tiff
announced via advisory DSA 1091-1.

Several problems have been discovered in the TIFF library.  The Common
Vulnerabilities and Exposures project identifies the following issues:

CVE-2006-2193

SuSE discovered a buffer overflow in the conversion of TIFF files
into PDF documents which could be exploited when tiff2pdf is used
e.g. in a printer filter.

CVE-2006-2656

The tiffsplit command from the TIFF library contains a buffer
overflow in the commandline handling which could be exploited when
the program is executed automatically on unknown filenames.

For the old stable distribution (woody) this problem has been fixed in
version 3.5.5-7woody2.

For the stable distribution (sarge) this problem has been fixed in
version 3.7.2-5.

For the unstable distribution (sid) this problem has been fixed in
version 3.8.2-4.

We recommend that you upgrade your tiff packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201091-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1091-1 (tiff)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libtiff-tools", ver:"3.5.5-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff3g", ver:"3.5.5-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff3g-dev", ver:"3.5.5-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff-opengl", ver:"3.7.2-5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff-tools", ver:"3.7.2-5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff4", ver:"3.7.2-5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff4-dev", ver:"3.7.2-5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiffxx0", ver:"3.7.2-5", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
