# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1142-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57211);
 script_cve_id("CVE-2006-3913");
 script_bugtraq_id(19117);
 script_version ("$");
 name = "Debian Security Advisory DSA 1142-1 (freeciv)";
 script_name(name);

 desc = "The remote host is missing an update to freeciv
announced via advisory DSA 1142-1.

Luigi Auriemma discovered missing boundary checks in freeciv, a clone
of the well known Civilisation game, which can be exploited by remote
attackers to cause a denial of service (crash) and possibly execute
arbitrary code.

For the stable distribution (sarge) these problems have been fixed in
version 2.0.1-1sarge2.

For the unstable distribution (sid) these problems will be fixed soon.

We recommend that you upgrade your freeciv package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201142-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1142-1 (freeciv)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"freeciv-data", ver:"2.0.1-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeciv-gtk", ver:"2.0.1-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeciv-xaw3d", ver:"2.0.1-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeciv", ver:"2.0.1-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeciv-client-gtk", ver:"2.0.1-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeciv-client-xaw3d", ver:"2.0.1-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeciv-server", ver:"2.0.1-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
