# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1191-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57485);
 script_cve_id("CVE-2006-2788", "CVE-2006-4340", "CVE-2006-4565", "CVE-2006-4566", "CVE-2006-4568", "CVE-2006-4570", "CVE-2006-4571");
 script_bugtraq_id(20042);
 script_version ("$");
 name = "Debian Security Advisory DSA 1191-1 (mozilla-thunderbird)";
 script_name(name);

 desc = "The remote host is missing an update to mozilla-thunderbird
announced via advisory DSA 1191-1.

Several security related problems have been discovered in Mozilla and
derived products such as Mozilla Thunderbird.  The Common
Vulnerabilities and Exposures project identifies the following
vulnerabilities:

CVE-2006-2788

Fernando Ribeiro discovered that a vulnerability in the getRawDER
functionallows remote attackers to cause a denial of service
(hang) and possibly execute arbitrary code.

CVE-2006-4340

Daniel Bleichenbacher recently described an implementation error
in RSA signature verification that cause the application to
incorrectly trust SSL certificates.

CVE-2006-4565, CVE-2006-4566

Priit Laes reported that that a JavaScript regular expression can
trigger a heap-based buffer overflow which allows remote attackers
to cause a denial of service and possibly execute arbitrary code.

CVE-2006-4568

A vulnerability has been discovered that allows remote attackers
to bypass the security model and inject content into the sub-frame
of another site.

CVE-2006-4570

Georgi Guninski demonstrated that even with JavaScript disabled in
mail (the default) an attacker can still execute JavaScript when a
mail message is viewed, replied to, or forwarded.

CVE-2006-4571

Multiple unspecified vulnerabilities in Firefox, Thunderbird and
SeaMonkey allow remote attackers to cause a denial of service,
corrupt memory, and possibly execute arbitrary code.

For the stable distribution (sarge) these problems have been fixed in
version 1.0.2-2.sarge1.0.8c.1.

For the unstable distribution (sid) these problems have been fixed in
version 1.5.0.7-1.

We recommend that you upgrade your Mozilla Thunderbird packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201191-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1191-1 (mozilla-thunderbird)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"1.0.2-2.sarge1.0.8c.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"1.0.2-2.sarge1.0.8c.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-thunderbird-inspector", ver:"1.0.2-2.sarge1.0.8c.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-thunderbird-offline", ver:"1.0.2-2.sarge1.0.8c.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-thunderbird-typeaheadfind", ver:"1.0.2-2.sarge1.0.8c.1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
