# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1260-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58015);
 script_cve_id("CVE-2007-0770", "CVE-2006-5456");
 script_version ("$");
 name = "Debian Security Advisory DSA 1260-1 (imagemagick)";
 script_name(name);

 desc = "The remote host is missing an update to imagemagick
announced via advisory DSA 1260-1.

Vladimir Nadvornik discovered that the fix for a vulnerability in the
PALM decoder of Imagemagick, a collection of image manipulation programs,
was ineffective. To avoid confusion a new CVE ID has been assigned;
tha original issue was tracked as CVE-2006-5456.

For the stable distribution (sarge) this problem has been fixed in
version 6:6.0.6.2-2.9.

For the upcoming stable distribution (etch) this problem has been
fixed in version 7:6.2.4.5.dfsg1-0.14.

For the unstable distribution (sid) this problems has been fixed in
version 7:6.2.4.5.dfsg1-0.14.

We recommend that you upgrade your imagemagick packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201260-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1260-1 (imagemagick)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"imagemagick", ver:"6.0.6.2-2.9", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++6", ver:"6.0.6.2-2.9", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++6-dev", ver:"6.0.6.2-2.9", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick6", ver:"6.0.6.2-2.9", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick6-dev", ver:"6.0.6.2-2.9", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perlmagick", ver:"6.0.6.2-2.9", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
