# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1266-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58121);
 script_cve_id("CVE-2007-1263");
 script_version ("$");
 name = "Debian Security Advisory DSA 1266-1 (gnupg)";
 script_name(name);

 desc = "The remote host is missing an update to gnupg
announced via advisory DSA 1266-1.

Gerardo Richarte discovered that GnuPG, a free PGP replacement, provides
insufficient user feedback if an OpenPGP message contains both unsigned
and signed portions. Inserting text segments into an otherwise signed
message could be exploited to forge the content of signed messages.
This update prevents such attacks; the old behaviour can still be
activated by passing the --allow-multiple-messages option.

For the stable distribution (sarge) these problems have been fixed in
version 1.4.1-1.sarge7.

For the upcoming stable distribution (etch) these problems have been
fixed in version 1.4.6-2.

For the unstable distribution (sid) these problems have been fixed in
version 1.4.6-2.

We recommend that you upgrade your gnupg packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201266-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1266-1 (gnupg)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gnupg", ver:"1.4.1-1.sarge7", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
