# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1277-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58329);
 script_cve_id("CVE-2007-0654", "CVE-2007-0653");
 script_bugtraq_id(23078);
 script_version ("$");
 name = "Debian Security Advisory DSA 1277-1 (xmms)";
 script_name(name);

 desc = "The remote host is missing an update to xmms
announced via advisory DSA 1277-1.

Multiple errors have been found in the skin handling routines in xmms,
the X Multimedia System.  These vulnerabilities could allow an
attacker to run arbitrary code as the user running xmms by inducing
the victim to load specially crafted interface skin files.

For the stable distribution (sarge), these problems have been fixed in
version 1.2.10+cvs20050209-2sarge1

For the upcoming stable distrubution (etch) and the unstable
distribution (sid), these problems have been fixed in versions
1:1.2.10+20061101-1etch1 and 1:1.2.10+20070401-1, respectively.

We recommend that you upgrade your xmms packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201277-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1277-1 (xmms)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"xmms", ver:"1.2.10+cvs20050209-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xmms-dev", ver:"1.2.10+cvs20050209-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
