# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1279-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58331);
 script_cve_id("CVE-2006-6669");
 script_version ("$");
 name = "Debian Security Advisory DSA 1279-1 (webcalendar)";
 script_name(name);

 desc = "The remote host is missing an update to webcalendar
announced via advisory DSA 1279-1.

It was discovered that WebCalendar, a PHP-based calendar application,
performs insufficient sanitising in the exports handler, which allows
injection of web script.

For the old stable distribution (sarge) this problem has been fixed in
version 0.9.45-4sarge7.

The stable distribution (etch) no longer contains WebCalendar packages.

For the unstable distribution (sid) this problem has been fixed in
version 1.0.5-2.

We recommend that you upgrade your webcalendar package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201279-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1279-1 (webcalendar)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"webcalendar", ver:"0.9.45-4sarge7", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
