# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1321-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58426);
 script_cve_id("CVE-2007-3257");
 script_version ("$");
 name = "Debian Security Advisory DSA 1321-1 (evolution-data-server)";
 script_name(name);

 desc = "The remote host is missing an update to evolution-data-server
announced via advisory DSA 1321-1.

It was discovered that the IMAP code in the Evolution Data Server
performs insufficient sanitising of a value later used an array index,
which can lead to the execution of arbitrary code.

For the oldstable distribution (sarge) a different source package
is affected and will be fixed separately.

For the stable distribution (etch) this problem has been fixed in
version 1.6.3-5etch1.

For the unstable distribution (sid) this problem has been fixed in
version 1.10.2-2.

We recommend that you upgrade your evolution-data-server packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201321-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1321-1 (evolution-data-server)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"evolution-data-server-common", ver:"1.6.3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"evolution-data-server", ver:"1.6.3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"evolution-data-server-dbg", ver:"1.6.3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"evolution-data-server-dev", ver:"1.6.3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcamel1.2-8", ver:"1.6.3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcamel1.2-dev", ver:"1.6.3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libebook1.2-5", ver:"1.6.3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libebook1.2-dev", ver:"1.6.3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecal1.2-6", ver:"1.6.3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecal1.2-dev", ver:"1.6.3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libedata-book1.2-2", ver:"1.6.3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libedata-book1.2-dev", ver:"1.6.3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libedata-cal1.2-5", ver:"1.6.3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libedata-cal1.2-dev", ver:"1.6.3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libedataserver1.2-7", ver:"1.6.3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libedataserver1.2-dev", ver:"1.6.3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libedataserverui1.2-6", ver:"1.6.3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libedataserverui1.2-dev", ver:"1.6.3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libegroupwise1.2-10", ver:"1.6.3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libegroupwise1.2-dev", ver:"1.6.3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libexchange-storage1.2-1", ver:"1.6.3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libexchange-storage1.2-dev", ver:"1.6.3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
