# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1358-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58577);
 script_cve_id("CVE-2007-1306", "CVE-2007-1561", "CVE-2007-2294", "CVE-2007-2297", "CVE-2007-2488", "CVE-2007-3762", "CVE-2007-3763", "CVE-2007-3764");
 script_version ("$");
 name = "Debian Security Advisory DSA 1358-1 (asterisk)";
 script_name(name);

 desc = "The remote host is missing an update to asterisk
announced via advisory DSA 1358-1.

Several remote vulnerabilities have been discovered in Asterisk, a free
software PBX and telephony toolkit. The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2007-1306

Mu Security discovered that a NULL pointer deference in the SIP
implementation could lead to denial of service.

CVE-2007-1561

Inria Lorraine discovered that a programming error in the SIP
implementation could lead to denial of service.

CVE-2007-2294

It was discovered that a NULL pointer deference in the manager
interface could lead to denial of service.

CVE-2007-2297

It was discovered that a programming error in the SIP implementation
could lead to denial of service.

CVE-2007-2488

Tim Panton and Birgit Arkestein discovered that a programming error
in the IAX2 implementation could lead to information disclosure.

CVE-2007-3762

Russell Bryant discovered that a buffer overflow in the IAX
implementation could lead to the execution of arbitrary code.

CVE-2007-3763

Chris Clark and Zane Lackey discovered that several NULL pointer
deferences in the IAX2 implementation could lead to denial of
service.

CVE-2007-3764

Will Drewry discovered that a programming error in the Skinny
implementation could lead to denial of service.

For the oldstable distribution (sarge) these problems have been fixed in
version 1.0.7.dfsg.1-2sarge5.

For the stable distribution (etch) these problems have been fixed
in version 1:1.2.13~dfsg-2etch1.

For the unstable distribution (sid) these problems have been fixed in
version 1:1.4.11~dfsg-1.

We recommend that you upgrade your Asterisk packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201358-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1358-1 (asterisk)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"asterisk-config", ver:"1.0.7.dfsg.1-2sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-dev", ver:"1.0.7.dfsg.1-2sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-doc", ver:"1.0.7.dfsg.1-2sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-sounds-main", ver:"1.0.7.dfsg.1-2sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-web-vmail", ver:"1.0.7.dfsg.1-2sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk", ver:"1.0.7.dfsg.1-2sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-gtk-console", ver:"1.0.7.dfsg.1-2sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-h323", ver:"1.0.7.dfsg.1-2sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-config", ver:"1.2.13~dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-dev", ver:"1.2.13~dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-doc", ver:"1.2.13~dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-sounds-main", ver:"1.2.13~dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-web-vmail", ver:"1.2.13~dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk", ver:"1.2.13~dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-bristuff", ver:"1.2.13~dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-classic", ver:"1.2.13~dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-h323", ver:"1.2.13~dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
