# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1361-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58580);
 script_cve_id("CVE-2007-3791");
 script_version ("$");
 name = "Debian Security Advisory DSA 1361-1 (postfix-policyd)";
 script_name(name);

 desc = "The remote host is missing an update to postfix-policyd
announced via advisory DSA 1361-1.


It was discovered that postfix-policyd, an anti-spam plugin for postfix,
didn't correctly bounds-test incoming SMTP commands potentially allowing
the remote exploitation of arbitrary code.

For the stable distribution (etch), this problem has been fixed in version
1.80-2.1etch1.

For the old stable distribution (sarge), this package was not present.

For the unstable distribution (sid), this problem was fixed in version
1.80-2.2.

We recommend that you upgrade your postfix-policyd package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201361-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1361-1 (postfix-policyd)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"postfix-policyd", ver:"1.80-2.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
