# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1399-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58731);
 script_cve_id("CVE-2007-1659", "CVE-2007-1660", "CVE-2007-1661", "CVE-2007-1662", "CVE-2007-4766", "CVE-2007-4767", "CVE-2007-4768");
 script_version ("$");
 name = "Debian Security Advisory DSA 1399-1 (pcre3)";
 script_name(name);

 desc = "The remote host is missing an update to pcre3
announced via advisory DSA 1399-1.

Tavis Ormandy of the Google Security Team has discovered several
security issues in PCRE, the Perl-Compatible Regular Expression library,
which potentially allow attackers to execute arbitrary code by compiling
specially crafted regular expressions.

Version 7.0 of the PCRE library featured a major rewrite of the regular
expression compiler, and it was deemed infeasible to backport the
security fixes in version 7.3 to the versions in Debian's stable and
oldstable distributions (6.7 and 4.5, respectively).  Therefore, this
update contains version 7.3, with special patches to improve the
compatibility with the older versions.  As a result, extra care is
necessary when applying this update.

The Common Vulnerabilities and Exposures project identifies the
following problems:

CVE-2007-1659

Unmatched \Q\E sequences with orphan \E codes can cause the compiled
regex to become desynchronized, resulting in corrupt bytecode that may
result in multiple exploitable conditions.

CVE-2007-1660

Multiple forms of character class had their sizes miscalculated on
initial passes, resulting in too little memory being allocated.

CVE-2007-1661

Multiple patterns of the form  \X?\d or \P{L}?\d in non-UTF-8 mode
could backtrack before the start of the string, possibly leaking
information from the address space, or causing a crash by reading out
of bounds.

CVE-2007-1662

A number of routines can be fooled into reading past the end of an
string looking for unmatched parentheses or brackets, resulting in a
denial of service.

CVE-2007-4766

Multiple integer overflows in the processing of escape sequences could
result in heap overflows or out of bounds reads/writes.

CVE-2007-4767

Multiple infinite loops and heap overflows were disovered in the
handling of \P and \P{x} sequences, where the length of these
non-standard operations was mishandled.

CVE-2007-4768

Character classes containing a lone unicode sequence were incorrectly
optimised, resulting in a heap overflow.

For the stable distribution (etch), these problems have been fixed in
version 6.7+7.4-2.

For the old stable distribution (sarge), these problems have been fixed in
version 4.5+7.4-1.

For the unstable distribution (sid), these problems have been fixed in
version 7.3-1.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201399-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1399-1 (pcre3)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"pgrep", ver:"4.5+7.4-1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpcre3-dev", ver:"4.5+7.4-1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpcre3", ver:"4.5+7.4-1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pcregrep", ver:"4.5+7.4-1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpcrecpp0", ver:"6.7+7.4-2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpcre3-dev", ver:"6.7+7.4-2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pcregrep", ver:"6.7+7.4-2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpcre3", ver:"6.7+7.4-2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
