# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1408-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(59235);
 script_cve_id("CVE-2007-5393");
 script_version ("$");
 name = "Debian Security Advisory DSA 1408-1 (kdegraphics)";
 script_name(name);

 desc = "The remote host is missing an update to kdegraphics
announced via advisory DSA 1408-1.

Alin Rad Pop discovered a buffer overflow in kpdf, which could allow
the execution of arbitrary code if a malformed PDF file is displayed.

For the stable distribution (etch), this problem has been fixed in
version 4:3.5.5-3etch2. Builds for arm and sparc are not yet available.

The old stable distribution (sarge) will be fixed later.

We recommend that you upgrade your kdegraphics packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201408-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1408-1 (kdegraphics)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kdegraphics-doc-html", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdegraphics", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kolourpaint", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kiconedit", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kfaxview", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kuickshow", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kooka", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kghostview", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdegraphics-dev", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kfax", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kview", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kpdf", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kmrml", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kpovmodeler", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdegraphics-kfile-plugins", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ksnapshot", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kruler", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkscan-dev", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kamera", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkscan1", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kcoloredit", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdegraphics-dbg", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdvi", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kgamma", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kviewshell", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ksvg", ver:"3.5.5-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
