# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1441-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(60074);
 script_cve_id("CVE-2007-6454");
 script_version ("$");
 name = "Debian Security Advisory DSA 1441-1 (peercast)";
 script_name(name);

 desc = "The remote host is missing an update to peercast
announced via advisory DSA 1441-1.

Luigi Auriemma discovered that PeerCast, a P2P audio and video streaming
server, is vulnerable to a heap overflow in the HTTP server code, which
allows remote attackers to cause a denial of service and possibly execute
arbitrary code via a long SOURCE request.

For the stable distribution (etch), this problem has been fixed in
version 0.1217.toots.20060314-1etch0.

The old stable distribution (sarge) does not contain peercast.

For the unstable distribution (sid), this problem has been fixed in
version 0.1218+svn20071220+2.

We recommend that you upgrade your peercast packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201441-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1441-1 (peercast)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"peercast-handlers", ver:"0.1217.toots.20060314-1etch0", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpeercast0", ver:"0.1217.toots.20060314-1etch0", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"peercast", ver:"0.1217.toots.20060314-1etch0", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpeercast0-dev", ver:"0.1217.toots.20060314-1etch0", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"peercast-servent", ver:"0.1217.toots.20060314-1etch0", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
