# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1467-1 (mantis)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60211);
 script_cve_id("CVE-2006-6574", "CVE-2007-6611");
 script_version ("$");
 name = "Debian Security Advisory DSA 1467-1 (mantis)";
 script_name(name);

 desc = "The remote host is missing an update to mantis
announced via advisory DSA 1467-1.

Several remote vulnerabilities have been discovered in Mantis, a web based
bug tracking system. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2006-6574

Custom fields were not appropriately protected by per-item access
control, allowing for sensitive data to be published.

CVE-2007-6611

Multiple cross site scripting issues allowed a remote attacker to
insert malicious HTML or web script into Mantis web pages.

The stable distribution (etch) is not affected by these problems.

For the old stable distribution (sarge), these problems have been fixed in
version 0.19.2-5sarge5.

For the unstable distribution (sid), these problems have been fixed in
version 1.0.8-4.

We recommend that you upgrade your mantis package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201467-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1467-1 (mantis)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mantis", ver:"0.19.2-5sarge5", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
