# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1468-1 (tomcat5.5)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60212);
 script_cve_id("CVE-2008-0128", "CVE-2007-2450");
 script_version ("$");
 name = "Debian Security Advisory DSA 1468-1 (tomcat5.5)";
 script_name(name);

 desc = "The remote host is missing an update to tomcat5.5
announced via advisory DSA 1468-1.

Several remote vulnerabilities have been discovered in the Tomcat
servlet and JSP engine. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2008-0128

Olaf Kock discovered that HTTPS encryption was insufficiently
enforced for single-sign-on cookies, which could result in
information disclosure.

CVE-2007-2450

It was discovered that the Manager and Host Manager web applications
performed insufficient input sanitising, which could lead to cross-
site scripting.

This update also adapts the tomcat5.5-webapps package to the tightened
JULI permissions introduced in the previous tomcat5.5 DSA. However, it
should be noted, that the tomcat5.5-webapps is for demonstration and
documentation purposes only and should not be used for production
systems.

For the unstable distribution (sid), these problems will be fixed soon.

For the stable distribution (etch), these problems have been fixed in
version 5.5.20-2etch2.

The old stable distribution (sarge) doesn't contain tomcat5.5.

We recommend that you upgrade your tomcat5.5 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201468-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1468-1 (tomcat5.5)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"tomcat5.5-admin", ver:"5.5.20-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtomcat5.5-java", ver:"5.5.20-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tomcat5.5", ver:"5.5.20-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tomcat5.5-webapps", ver:"5.5.20-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
