# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1469-1 (flac)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60214);
 script_cve_id("CVE-2007-4619", "CVE-2007-6277");
 script_version ("$");
 name = "Debian Security Advisory DSA 1469-1 (flac)";
 script_name(name);

 desc = "The remote host is missing an update to flac
announced via advisory DSA 1469-1.

Sean de Regge and Greg Linares discovered multiple heap and stack based
buffer overflows in FLAC, the Free Lossless Audio Codec, which could
lead to the execution of arbitrary code.

For the unstable distribution (sid), these problems have been fixed in
version 1.2.1-1.

For the stable distribution (etch), these problems have been fixed in
version 1.1.2-8.

For the old stable distribution (sarge), these problems have been
fixed in version 1.1.1-5sarge1.

We recommend that you upgrade your flac packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201469-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1469-1 (flac)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"xmms-flac", ver:"1.1.1-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liboggflac-dev", ver:"1.1.1-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libflac6", ver:"1.1.1-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liboggflac++0c102", ver:"1.1.1-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liboggflac1", ver:"1.1.1-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"flac", ver:"1.1.1-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liboggflac++-dev", ver:"1.1.1-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libflac-dev", ver:"1.1.1-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libflac++4", ver:"1.1.1-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libflac++-dev", ver:"1.1.1-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libflac-doc", ver:"1.1.2-8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libflac++5", ver:"1.1.2-8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libflac++-dev", ver:"1.1.2-8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liboggflac++2", ver:"1.1.2-8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liboggflac-dev", ver:"1.1.2-8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liboggflac3", ver:"1.1.2-8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xmms-flac", ver:"1.1.2-8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libflac-dev", ver:"1.1.2-8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libflac7", ver:"1.1.2-8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liboggflac++-dev", ver:"1.1.2-8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"flac", ver:"1.1.2-8", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
