# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1506-1 (iceape)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60441);
 script_cve_id("CVE-2008-0412", "CVE-2008-0413", "CVE-2008-0414", "CVE-2008-0415", "CVE-2008-0417", "CVE-2008-0418", "CVE-2008-0419", "CVE-2008-0591", "CVE-2008-0592", "CVE-2008-0593", "CVE-2008-0594");
 script_version ("$");
 name = "Debian Security Advisory DSA 1506-1 (iceape)";
 script_name(name);

 desc = "The remote host is missing an update to iceape
announced via advisory DSA 1506-1.

Several remote vulnerabilities have been discovered in the Iceape internet
suite, an unbranded version of the Seamonkey Internet Suite.
For details, please visit the referenced security advisories.

For the stable distribution (etch), these problems have been fixed in
version 1.0.12~pre080131b-0etch1.

The Mozilla releases from the old stable distribution (sarge) are no
longer supported with security updates.

We recommend that you upgrade your iceape packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201506-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1506-1 (iceape)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mozilla", ver:"1.8+1.0.12~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-calendar", ver:"1.8+1.0.12~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-js-debugger", ver:"1.8+1.0.12~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceape-chatzilla", ver:"1.0.12~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceape-dev", ver:"1.0.12~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-dom-inspector", ver:"1.8+1.0.12~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceape", ver:"1.0.12~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-chatzilla", ver:"1.8+1.0.12~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-dev", ver:"1.8+1.0.12~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-mailnews", ver:"1.8+1.0.12~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-psm", ver:"1.8+1.0.12~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-browser", ver:"1.8+1.0.12~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceape-dom-inspector", ver:"1.0.12~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceape-dbg", ver:"1.0.12~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceape-gnome-support", ver:"1.0.12~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceape-calendar", ver:"1.0.12~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceape-mailnews", ver:"1.0.12~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceape-browser", ver:"1.0.12~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
