# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1525-1 (asterisk)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60616);
 script_cve_id("CVE-2007-6430", "CVE-2008-1332", "CVE-2008-1333");
 script_version ("$");
 name = "Debian Security Advisory DSA 1525-1 (asterisk)";
 script_name(name);

 desc = "The remote host is missing an update to asterisk
announced via advisory DSA 1525-1.

Several remote vulnerabilities have been discovered in Asterisk, a free
software PBX and telephony toolkit. The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2007-6430

Tilghman Lesher discovered that database-based registrations are
insufficiently validated. This only affects setups, which are
configured to run without a password and only host-based
authentication.

CVE-2008-1332

Jason Parker discovered that insufficient validation of From:
headers inside the SIP channel driver may lead to authentication
bypass and the potential external initiation of calls.

This update also fixes a format string vulnerability, which can only
be triggered through configuration files under control of the local
administrator. In later releases of Asterisk this issue is remotely
exploitable and tracked as CVE-2008-1333.

For the stable distribution (etch), these problems have been fixed in
version 1:1.2.13~dfsg-2etch3.

The status of the old stable distribution (sarge) is currently being
investigated. If affected, an update will be released through
security.debian.org.

We recommend that you upgrade your asterisk packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201525-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1525-1 (asterisk)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"asterisk-doc", ver:"1.2.13~dfsg-2etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-sounds-main", ver:"1.2.13~dfsg-2etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-config", ver:"1.2.13~dfsg-2etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-web-vmail", ver:"1.2.13~dfsg-2etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-dev", ver:"1.2.13~dfsg-2etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk", ver:"1.2.13~dfsg-2etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-bristuff", ver:"1.2.13~dfsg-2etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-h323", ver:"1.2.13~dfsg-2etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-classic", ver:"1.2.13~dfsg-2etch3", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
