# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1531-2 (policyd-weight)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60656);
 script_version ("$");
 name = "Debian Security Advisory DSA 1531-2 (policyd-weight)";
 script_name(name);

 desc = "The remote host is missing an update to policyd-weight
announced via advisory DSA 1531-2.

The previous update for policyd-weight was unfortunately not complete.
Updated packages have been released that fully address the vulnerability.
For reference the original advisory follows.

Chris Howells discovered that policyd-weight, a policy daemon for the Postfix
mail transport agent, created its socket in an insecure way, which may be
exploited to overwrite or remove arbitary files from the local system.

For the stable distribution (etch), this problem has been fixed in version
0.1.14-beta-6etch2.

The old stable distribution (sarge) does not contain a policyd-weight package.

For the unstable distribution (sid), this problem will be fixed soon.


We recommend that you upgrade your policyd-weight package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201531-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1531-2 (policyd-weight)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"policyd-weight", ver:"0.1.14-beta-6etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
